#!/usr/bin/perl
# $Id: select_service.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: select_service.cgi
# Desc: create the "Current Definitions" navigation page
#       dynamically with all available services
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: select_service.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:19  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:46  jens
# .
#
# Revision 1.1  1999/08/01 21:44:46  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:39  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:23  jens
# initial ci -r 1.0
#
#
 
$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

$cfg_dir = "$fwdir/etc/config";

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
  }
}

sub list_service {
  my $ok, $file;

  foreach $service ( @_ ) {
    $file = "$fwdir/rules/$service.rules"; $ok = 0;
    if ( -r $file) {$ok = 1;}
    unless ( $type eq "tst" and ! $ok ) {
      print "\n<LI>";
      print "<A HREF=\"../cgi-bin/";
      print "$cgi_file?$service\" TARGET=\"config\">";
      print "$service</A>";
      print "*" if ( $ok and $type ne "tst" );
      print "</LI>\n";
    }
  }
}

#
# get all defined "services" from '<service>.def' in 'etc/config'
# -> @services
#
$type = $ARGV[0];

if ( $type eq "def" or
     $type eq "tst" or
     $type eq "flt" ) {
  opendir CFG_DIR, $cfg_dir;
  @files = grep /^[a-zA-Z]\w*\.def$/, readdir CFG_DIR;
  closedir CFG_DIR;
  foreach $file (sort @files) {
    ($serv, $suffix) = split /\./, $file;
    @services = (@services , $serv);
  }
  if ( $type eq "def" or
       $type eq "flt" ) {
    $cgi_file = "fill_service_$type.cgi";
  } else {
    $cgi_file = "rules_test.cgi";
  }
} else {
  opendir CFG_DIR, $cfg_dir;
  @def_files = grep /\.def$/, readdir CFG_DIR;
  closedir CFG_DIR;
  opendir CFG_DIR, $cfg_dir;
  @flt_files = grep /^[a-zA-Z]\w*\.flt$/, readdir CFG_DIR;
  closedir CFG_DIR;
  foreach $file (sort @def_files) {
   ($serv, $suffix) = split /\./, $file;
   if (grep /$serv/, @flt_files) {
     @services = (@services ,$serv);
   }
  }
  $cgi_file = "create_service_$type.cgi";
}

#
# list all available services (html)
#
print "Content-type: text/html\n\n";

print_file ($fwdir . "/etc/sheets/select_service_head.htm");

unless ( $type eq "def" or $type eq "flt"  or $type eq "tst" ) {
      print "\n<LI><A HREF=\"../cgi-bin/";
      print "create_fw_rules.cgi\" TARGET=\"config\">";
      print "Firewall</A>";
      print "*" if ( -r "$fwdir/rules/Firewall.rules" );
      print "</LI>\n";
      print "\n<LI><A HREF=\"../cgi-bin/";
      print "create_trusted_rules.cgi\" TARGET=\"config\">";
      print "Trusted Hosts</A>";
      print "*" if ( -r "$fwdir/rules/Trusted.rules" );
      print "</LI>\n";
    }
if ( $type eq "tst" ) {
      print "\n<LI><A HREF=\"../cgi-bin/";
      print "$cgi_file?Firewall\" TARGET=\"config\">";
      print "Firewall</A></LI>\n";
      print "\n<LI><A HREF=\"../cgi-bin/";
      print "$cgi_file?Trusted\" TARGET=\"config\">";
      print "Trusted Hosts</A></LI>\n";
    }
print "<p>\n";
list_service (@services);
print "</p>\n";
print_file ($fwdir . "/etc/sheets/select_service_end.htm");
