#!/usr/bin/perl
# $Id: form_flt_service.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: form_flt_service.cgi - Firewall Configuration Tool
# Desc: interprete the service routing/filtering form
#       and create the config-file etc/config/<service>.flt
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_flt_service.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:19  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:39  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:23  jens
# initial ci -r 1.0
#
#

@Names = ( "service",
           "src_1",  "dst_1", "dir_1", "log_1",
           "src_2",  "dst_2", "dir_2", "log_2",
           "src_3",  "dst_3", "dir_3", "log_3",
         );

%Wert = ( 'service', '',
          'src_1',   '', 'dst_1',  '', 'dir_1',  '',  'log_1',  '',
          'src_2',   '', 'dst_2',  '', 'dir_2',  '',  'log_2',  '',
          'src_3',   '', 'dst_3',  '', 'dir_3',  '',  'log_3',  '',
         );

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

&read_form;
$_ = $Wert{'service'};

if ( /^\s*$/ ) {
  print "Content-type: text/plain\n\n";
  print "\n\nERROR:\n\n";
  print "-----> Please select a service.\n";
} elsif ( !/^[a-z]/ ) {
  print "Content-type: text/plain\n\n";
  print "\n\nERROR:\n\n";
  print "-----> Service name must begin with a lowercase letter.\n";
  print "Uppercase Services are reserved for SPECIAL USAGE, so You have to DEFINE THEM BY HAND.\n";
} elsif ( -f "$fwdir/etc/config/$Wert{'service'}.def" ) {
    &create_file;
    &print_file;
} else {
    print "Content-type: text/plain\n\n";
    print "\n\nERROR: The service $Wert{'service'} isnt defined.\n\n";
    print "-----> Please define the service first.\n";
}

sub read_form {
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);
 
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/('|,)//g;
        $value =~ s/<!--(.|\n)*-->//g;
        $value =~ s/[^\w\d\s\$_:\.]//g;

        if (defined ($Wert{$name})) {
            $Wert{$name} = $value;
        }
    }
}

sub print_form
{
    print "Content-type: text/plain\n\n";
    foreach $name (@Names)
    {
        print "$name='$Wert{$name}'\n";

    }
}

sub create_file
{
    $file = "$fwdir/etc/config/$Wert{'service'}.flt";
    unlink $file if -e $file;
    open (FH, ">$file");
    print FH "# File: etc/config/$Wert{'service'}.flt - Firewall Configuration Tool\n";
    print FH "# Desc: Filtering rules for Service $Wert{'service'}\n";
    print FH "#\n# (c) Copyright 1998 J. Friedrich\n#\n";
    print FH "# The Service will be routed:\n# From <src_x>  To <dst_x>  in <dir_x> direction(s)\n\n";
    print FH "# 1. Set\n";
    printf FH "%-40s ;%-40s ;%-13s ;%s\n\n","src_1='$Wert{'src_1'}'","dst_1='$Wert{'dst_1'}'","dir_1='$Wert{'dir_1'}'","log_1='$Wert{'log_1'}'";
    print FH "# 2. Set\n";
    printf FH "%-40s ;%-40s ;%-13s ;%s\n\n","src_2='$Wert{'src_2'}'","dst_2='$Wert{'dst_2'}'","dir_2='$Wert{'dir_2'}'","log_2='$Wert{'log_2'}'";
    print FH "# 3. Set\n";
    printf FH "%-40s ;%-40s ;%-13s ;%s\n","src_3='$Wert{'src_3'}'","dst_3='$Wert{'dst_3'}'","dir_3='$Wert{'dir_3'}'","log_3='$Wert{'log_3'}'";
    close (FH);
}

sub print_file
{
    # $file = "$fwdir/etc/config/$Wert{'service'}.flt";
    open (FH, "$file");
    print "Content-type: text/html\n\n<pre>";
    while (<FH>) {
        print ;
    }
    close (FH);
    print "</pre><hr>Back to <A HREF=\"../html/frame_service_flt.htm\" TARGET=\"firewall\">Screening</A>\n";
}

