#!/usr/bin/perl
# $Id: form_def_service.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: form_def_service.cgi - Firewall Configuration Tool
# Desc: interprete the service definition form
#       and create the config-file etc/config/<service>.def
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_def_service.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:19  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:39  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:22  jens
# initial ci -r 1.0
#
#

use File::Copy;

%Wert = ( 'service', '',
          'tcp_src_i',   '', 'tcp_dst_i',  '', 'tcp_log_i',  '',
          'tcp_src_o',   '', 'tcp_dst_o',  '', 'tcp_log_o',  '',
          'udp_src_i',   '', 'udp_dst_i',  '', 'udp_log_i',  '',
          'udp_src_o',   '', 'udp_dst_o',  '', 'udp_log_o',  '',
          'icmp_src_i',  '', 'icmp_dst_i', '', 'icmp_log_i', '',
          'icmp_src_o',  '', 'icmp_dst_o', '', 'icmp_log_o', '',
          'DELETE_SERVICE_DEF',  ''
         );

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

&read_form;

if ( $Wert{'DELETE_SERVICE_DEF'} =~ /^Delete/ ) {

  # delete the services config/rules files
  if ( -f "$fwdir/etc/config/$Wert{'service'}.def" ) {
    unlink "$fwdir/etc/config/$Wert{'service'}.def";
    unlink "$fwdir/etc/config/$Wert{'service'}.flt";
  }
  if ( -f "$fwdir/rules/$Wert{'service'}.rules" ) {
    unlink "$fwdir/rules/$Wert{'service'}.rules";
  }
  if ( -f "$fwdir/rules/Firewall/$Wert{'service'}.rules" ) {
    unlink "$fwdir/rules/Firewall/$Wert{'service'}.rules";
  }

  print "Content-type: text/html\n\n";
  print '<p><FONT Size=+1><br>The definition for service <b>' . "$Wert{'service'}" . '</b> is deleted.<br></FONT></p>';
  print "<hr>Back to <A HREF=\"../html/frame_service_def.htm\" TARGET=\"firewall\">Definition</A>\n";
}
else {

  # the service will be defined, if name is valid
  $_ = $Wert{'service'};
  if ( /^\s*$/ ) {
    print "Content-type: text/plain\n\n";
    print "\n\nERROR:\n\n";
    print "-----> Please select a service.\n";
  }
  elsif ( !/^[a-z]/ ) {
    print "Content-type: text/plain\n\n";
    print "\n\nERROR:\n\n";
    print "-----> Service name must begin with a lowercase letter.\n";
    print "Uppercase Services are reserved for SPECIAL USAGE, so You have to DEFINE THEM BY HAND.\n";
  }
  else {

    # create the service config-files
    &create_file;
    &print_file;

    if ( ! -f "$fwdir/etc/config/$Wert{'service'}.flt" ) {
      copy ( "$fwdir/etc/sheets/service_flt_template.flt",
         "$fwdir/etc/config/$Wert{'service'}.flt" );
    }
  }
}

sub read_form {
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);
 
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/('|,)//g;
        $value =~ s/<!--(.|\n)*-->//g;
        $value =~ s/[^\w\d\s\$_:\.!]//g;
        
        if (defined ($Wert{$name})) {
            $Wert{$name} = $value;
        }
    }
}

sub create_file
{
    $file = "$fwdir/etc/config/$Wert{'service'}.def";
    unlink $file if -e $file;
    open (FH, ">$file");
    print  FH "# File: etc/config/$Wert{'service'}.def - Firewall Configuration Tool\n";
    print  FH "# Desc: Definition for Service $Wert{'service'}\n";
    print  FH "#\n# (c) Copyright 1998 J. Friedrich\n#\n";
    print  FH "\n# Outgoing connections\n";
    printf FH "%-35s;%-35s;%s\n","tcp_src_o='$Wert{'tcp_src_o'}'",  "tcp_dst_o='$Wert{'tcp_dst_o'}'",  "tcp_log_o='$Wert{'tcp_log_o'}'";
    printf FH "%-35s;%-35s;%s\n","udp_src_o='$Wert{'udp_src_o'}'",  "udp_dst_o='$Wert{'udp_dst_o'}'",  "udp_log_o='$Wert{'udp_log_o'}'";
    printf FH "%-35s;%-35s;%s\n","icmp_src_o='$Wert{'icmp_src_o'}'","icmp_dst_o='$Wert{'icmp_dst_o'}'","icmp_log_o='$Wert{'icmp_log_o'}'";
    print  FH "\n# Incoming connections\n";
    printf FH "%-35s;%-35s;%s\n","tcp_src_i='$Wert{'tcp_src_i'}'",  "tcp_dst_i='$Wert{'tcp_dst_i'}'",  "tcp_log_i='$Wert{'tcp_log_i'}'";
    printf FH "%-35s;%-35s;%s\n","udp_src_i='$Wert{'udp_src_i'}'",  "udp_dst_i='$Wert{'udp_dst_i'}'",  "udp_log_i='$Wert{'udp_log_i'}'";
    printf FH "%-35s;%-35s;%s\n","icmp_src_i='$Wert{'icmp_src_i'}'","icmp_dst_i='$Wert{'icmp_dst_i'}'","icmp_log_i='$Wert{'icmp_log_i'}'";
    close (FH);
}

sub print_file
{
    $file = "$fwdir/etc/config/$Wert{'service'}.def";
    open (FH, "$file");
    print "Content-type: text/html\n\n<pre>";
    while (<FH>) {
        print ;
    }
    close (FH);
    print "</pre><hr>Back to <A HREF=\"../html/frame_service_def.htm\" TARGET=\"firewall\">Definition</A>\n";
}

