#!/usr/bin/perl
# $Id: form_cfg_trusted.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: flt_service.cgi
# Desc: create the file which defines the filtering rules
#       for a service
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_cfg_trusted.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:18  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:38  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:22  jens
# initial ci -r 1.0
#
#

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

@Hosts=();
@Devs=();
@Fw=();
@Log=();

&read_form;
&create_file;
&print_file;

sub read_form {

    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    $cnt=0;
    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);
 
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        next if $name =~ /^SUBMIT/;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/('|,|\s)//g;
        $value =~ s/<!--(.|\n)*-->//g;
        $value =~ s/[^\w\d\s\$_:\.]//g;

SWITCH: {
            $name =~ /trusted_host/ && do {
                     if ( ( $cnt == 0 || $cnt >= 2 ) && $value =~ /\S+.*/  ) {
                         push @Hosts, "$value";
                         push @Fw,    "" if $cnt == 2;
                         push @Log,   "" if $cnt == 2 || $cnt == 3;
                         $cnt=1;
                     };
                     last SWITCH;
            };

            $name =~ /trusted_dev/ && do {
                     if ( $cnt == 1 && $value =~ /\S+.*/  ) {
                         push @Devs, "$value";
                         $cnt=2;
                     } else {
                         pop  @Hosts     if $cnt == 1;;
                         push @Fw,    "" if $cnt == 2;
                         push @Log,   "" if $cnt == 2 || $cnt == 3;
                         $cnt = 0;
                     }
                     last SWITCH;
            };

            $name =~ /trusted_fw/ && do {
                     if ( $cnt == 2  && $value =~ /\S+.*/ ) {
                         push @Fw, "$value";
                         $cnt=3;
                     } else {
                         pop @Hosts if $cnt == 1;
                     }
                     last SWITCH;
            };

            $name =~ /trusted_log/ && do {
                     if ( $cnt >= 2 && $value =~ /\S+.*/  ) {
                         push @Log, "$value";
                         push @Fw,  "" if $cnt == 2;
                         $cnt=4;
                     } else {
                         pop @Hosts if $cnt == 1;
                     }
                     last SWITCH;
            };
        }
    }
}

sub create_file
{
    $file = "$fwdir/etc/trusted.cfg";
    unlink $file if -e $file;
    open (FH, ">$file");
    print FH "# File: etc/trusted.cfg - Firewall Configuration Tool\n";
    print FH "# Desc: Configuration of your Trusted IPs and devices\n#\n";
    print FH "# (c) Copyright 1998 J. Friedrich\n\n";
    while (@Hosts)
    {
        printf FH "%-38s ;%-20s ;%-20s ;%s\n","trusted_host='$Hosts[0]'","trusted_dev='$Devs[0]'","trusted_fw='$Fw[0]'","trusted_log='$Log[0]'" if $Hosts[0] =~ /^.+.*/;
        shift @Hosts; shift @Devs; shift @Fw; shift @Log;
    }
    close (FH);
}

sub print_file
{
    $file = "$fwdir/etc/trusted.cfg";
    open (FH, "$file");
    print "Content-type: text/html\n\n<pre>";
    while (<FH>) {
        print ;
    }
    close (FH);
    print "</pre><hr>Back to <A HREF=\"../cgi-bin/fill_trusted_cfg.cgi\" TARGET=\"firewall\">Trusted</A>\n";
}

