#!/usr/bin/perl
# $Id: form_cfg_services.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: form_cfg_services.cgi
# Desc: interprete the configuration form
#       and create the config-file etc/services.cfg
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_cfg_services.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:18  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.1  1998/10/27 19:43:34  jens
# entered into RCS
#
# Revision 1.0.9.1  1998/06/01 19:34:38  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:22  jens
# initial ci -r 1.0
#
#

use File::Copy;

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

$fl = "services";
$fhead="$fwdir/etc/cfg_header/$fl.header";
$fconfig="$fwdir/etc/$fl.cfg";

sub read_form {

    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    open (CFG, ">>$_[0]");

    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);

        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        next if $name =~ /^SUBMIT/;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/('|,)//g;
        $value =~ s/<!--(.|\n)*-->//g;
        $value =~ s/[^\w\d\s\$_:\.]//g;

        next if $value =~ /^\s*$/;

        if ($name =~ /^([ip]|ip)mq_/) {
            printf CFG "; %25s=\"%s\"", $name, $value;
        }
        else {
            printf CFG "\n%20s=%-10s", $name, "\"$value\"";
        };
    }
    print CFG "\n\nfi\n";
    close (CFG);
}

sub print_file
{
    open (FH, "$_[0]");
    print "Content-type: text/html\n\n<pre>";
    while (<FH>) {
        print ;
    }
    close (FH);
    print "</pre><hr>(c) Copyright 1998 J. Friedrich\n";
}

unlink $fconfig if -e $fconfig;
copy ("$fhead", "$fconfig");
&read_form ($fconfig);
print_file ($fconfig);

