#!/usr/bin/perl
# $Id: form_cfg_fw.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: form_cfg_fw.cgi
# Desc: interprete the Firewall form
#       and create the config-file etc/fw.cfg
# 
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_cfg_fw.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:18  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:38  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:22  jens
# initial ci -r 1.0
#
#

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

%Wert = ( 'fw_service', '',
          'fw_svc_def', '',
          'fw_dir',     ''
        );

@Services=();
@Def=();
@Dir=();
$denied='';

&read_form;
&create_file;
if ( $err_svc ) {
    print "Content-type: text/plain\n\n";
    print "\n\nERROR: The service $err_svc isnt defined.\n\n";
    print "-----> Please define the service first.\n";
} else {
  &print_file;
}

sub read_form {

    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    $cnt=0;
    @sort_array = ();
    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);
 
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        next if $name =~ /^SUBMIT/;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/('|,)//g;
        $value =~ s/<!--(.|\n)*-->//g;
        $value =~ s/[^\w\d\s\$_:\.]//g;

        next if $value =~ /^\s*$/;

        if ( $name =~ /deny_hosts/ ) {
          $denied = $value;
          next;
        }

        if ( $name =~ /fw_service/ ) {
          $service = "$value";
          $cnt = 1;
        } elsif ( ($cnt == 1) && ($name =~ /fw_svc_def/) ) { 
          $def = "$value";
          $cnt++;
        } elsif ( $cnt == 2 ) { 
          @sort_array = (@sort_array, "$service;$def;$value");
          $cnt=0;
        }
    }
    @sorted_array = (sort @sort_array);
    @Services = (); @Def = (); @Dir = ();
    foreach $_ (@sorted_array) {
      /(.+);(.+);(.+)/;
      @Services = (@Services, $1);
      @Def = (@Def, $2);
      @Dir = (@Dir, $3);
    }
}

sub create_file
{
    $file = "$fwdir/etc/fw.cfg";
    unlink $file if -e $file;
    open (FH, ">$file");
    print FH "# File: etc/fw.cfg - Firewall Configuration Tool\n";
    print FH "# Desc: Configuration of your Firewall-Host\n#\n";
    print FH "# (c) Copyright 1998 J. Friedrich\n\n";
    print FH "deny_hosts='$denied'\n";
    while (@Services)
    {
      if ( $Services[0] =~ /^.+$/ && $Def[0] =~ /^.+$/ ) {
        if ( -f "$fwdir/etc/config/$Services[0].def" ) {
          printf FH "%-30s %-40s %s\n", "fw_service=$Services[0];", "fw_svc_def='$Def[0]';", "fw_svc_dir=$Dir[0]";
        }
        else
        {
          $err_svc=$Services[0];
        }
      }
      shift @Services; shift @Def; shift @Dir;
    }
    close (FH);
}

sub print_file
{
    $file = "$fwdir/etc/fw.cfg";
    open (FH, "$file");
    print "Content-type: text/html\n\n<pre>";
    while (<FH>) {
        print ;
    }
    close (FH);
    print "</pre><hr>Back to <A HREF=\"../cgi-bin/fill_fw_cfg.cgi\">Firewall</A>\n";
}

