#!/usr/bin/perl
# $Id: form_cfg_aliases.cgi,v 1.1.5.1 2000/07/16 11:59:52 root Exp root $
# $Date: 2000/07/16 11:59:52 $
#
# File: form_cfg_aliases.cgi
# Desc: interprete the aliases form
#       and create the config-file etc/aliases.cfg
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: form_cfg_aliases.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:52  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:44  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:45  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:38  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:22  jens
# initial ci -r 1.0
#
#

%Wert = ( 'CFG_ALIASES', '' );

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

&read_form;
&create_file;
&print_file;

sub read_form {
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);

    foreach $pair (@pairs)
    {
        local($name, $value) = split(/=/, $pair);
 
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $name =~ s/('|,)//g;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/<!--(.|\n)*-->//g;
        # only some characters are allowed!
        $value =~ s/[^\w\d\s='\/\$_;:\.#+-]//g;
        
        if (defined ($Wert{$name})) {
            $Wert{$name} = $value;
        }
    }
}

sub create_file
{
    foreach $line (split (/\n/, $Wert{'CFG_ALIASES'})) {
        chomp ($line);
        $alias_line = "";
        ($def, $comment) = split(/#/, $line);
        ($var, $value) = split(/=/, $def);
        $var =~ s/^\s*//g;
        $value =~ s/[\r\n]//g;

        if ( $var =~ /^[\w\d_]+$/ ) {
          if ( $value =~ /^'[\w\d\s\/\$_\.:]*'\s*;*\s*$/ ) {
                 $alias_line = "$var=$value ";
          } elsif ( $value =~ /^[\w\d\s\/\$_\.:]*\s*;*\s*$/ ) {
                 $alias_line = "$var=\"$value\" ";
          } else {
                 $alias_line = "    # CODE SKIPPED: $def" unless ($var =~ /^\s*$/);
          }
        }
        else
        {
            $alias_line = "    # CODE SKIPPED: $def" unless ($var =~ /^\s*$/);
        }

        $alias_line .= '#' . $comment if $comment;
        $alias_line = $line if $line =~ /^\s*$/;

        push (@Aliases, "$alias_line") if $alias_line;
    }

    $file = "$fwdir/etc/aliases.cfg";
    unlink $file if -e $file;
    open (FH, ">$file");
    foreach $l (@Aliases) {
        chop ($l);
        print FH "$l\n";
    }
    close (FH);
}

sub print_file
{
    $file = "$fwdir/etc/aliases.cfg";
    open (FH, "$file");
    print "Content-type: text/plain\n\n";
    while (<FH>) {
        print ;
    }
    close (FH);
}
