#!/usr/bin/perl
# $Id: fill_trusted_cfg.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_trusted_cfg.cgi
# Desc: fill the 'trusted hosts' form
#       with the current definitions
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_trusted_cfg.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:43  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:45  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:37  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:21  jens
# initial ci -r 1.0
#
#
 
$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
  }
}

sub list_trusted {
  foreach $trust_def ( @_ ) {
    chomp(($t_host, $dev) = split (/=/, $trust_def));
    ($dummy, $host) = split (/_/, $t_host);
    ($dev, $check, $log) = split (/;/, $dev);
    next if $host =~ /^\s$/;

    print "<tr>\n";
    print "    <td><input type=\"text\" size=\"16\" name=\"trusted_host\" value=\"$host\"></td>\n";
    print "    <td><input type=\"text\" size=\"16\" name=\"trusted_dev\" value=\"$dev\"></td>\n";
    print "    <td><input type=\"checkbox\" name=\"trusted_fw\" value=\"checked\" $check> allowed&nbsp;</td>\n";
    print "    <td><input type=\"checkbox\" name=\"trusted_log\" value=\"checked\" $log> Log</td>\n";
    print "</tr>\n";
  }
  print "<tr>\n";
  print "    <td><input type=\"text\" size=\"16\" name=\"trusted_host\" value=\"\"></td>\n";
  print "    <td><input type=\"text\" size=\"16\" name=\"trusted_dev\" value=\"\"></td>\n";
  print "    <td><input type=\"checkbox\" name=\"trusted_fw\" value=\"checked\"> allowed&nbsp;</td>\n";
  print "    <td><input type=\"checkbox\" name=\"trusted_log\" value=\"checked\"> Log</td>\n";
  print "</tr>\n";
}

# read the selected service-configuration
# from etc/trusted.cfg
# -> @trusted_cfg

open TRUSTED_CFG, "$fwdir/etc/trusted.cfg";
do {
    chomp ( $line = <TRUSTED_CFG> );
} while ( grep !/^(#|\s*$)/, $line );
while ( <TRUSTED_CFG> ) {
  if ( grep !/^(#| |fi|\n)/, $_ ) {
    $_ =~ s/[=|;]//g;
    ($hnam, $host, $dnam, $dev, $cnam, $check, $lnam, $log) = split (/'|\"\s*;/, $_);
    push @trusted, "trusted_$host=$dev;$check;$log";
  }
}

#
# print the results (html)
#
print "Content-type: text/html\n\n";

print_file ($fwdir . "/etc/sheets/trusted_cfg_head.htm");
list_trusted (@trusted);
print_file ($fwdir . "/etc/sheets/trusted_cfg_end.htm");

close TRUSTED_CFG;
