#!/usr/bin/perl
# $Id: fill_services_cfg.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_services_cfg.cgi
# Desc: fill the configuration form
#       with the current definitions
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_services_cfg.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:42  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.1  1998/10/28 21:57:12  jens
# entered into RCS
#
# Revision 1.0.9.2  1998/06/02 18:00:41  jens
# *** empty log message ***
#
# Revision 1.0.9.1  1998/06/01 19:34:37  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:21  jens
# initial ci -r 1.0
#
#
 
$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

$cfg_dir = "$fwdir/etc/config";

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
  }
}

sub list_services {
  $cnt=0;
  foreach ( @_ ) {
    #chomp ($_);
    ($service, $def) = /(.*?)=(.*?)[;\s].*$/;
    ($imq) = /.*imq_.*?="*(.*?)"*[;\s].*$/;
    ($pmq) = /.*[^i]pmq_.*?="*(.*)\b.*$/;
    ($ipmq)= /.*ipmq_.*?="*(.*)\b.*$/;
    #next unless ( -r "$cfg_dir/$service.def" );
    $service =~ s/^\s*//g;

    if ( ++$cnt == 2 ) {
      $trb=''; $tre='</tr>'; $cnt=0;
    } else {
      $trb='<tr>'; $tre='';
    }
    $sel_b='';$sel_f='';$sel_i='';$sel_o='';

    if ( $def =~ /OUT/ ) {
      $sel_o="selected";
    } elsif ( $def =~ /FILTERED/ ) {
      $sel_f="selected";
    } elsif ( $def =~ /IN/ ) {
      $sel_i="selected";
    } else {
      $sel_b="selected";
    }
    if ( $imq =~ /true/ ) {
      $imq=checked;
    }
    if ( $pmq =~ /true/ ) {
      $pmq=checked;
    }
    if ( $ipmq =~ /true/ ) {
      $ipmq=checked;
    }

    print "$trb\n";
    print "    <td align=\"right\"> $service</td>\n";
    print "    <td><select name=\"$service\" size=\"1\">\n";
    print "        <option $sel_b value=\"BLOCKED\">Blocked</option>\n";
    print "        <option $sel_f value=\"FILTERED\">Filtered</option>\n";
    print "        <option $sel_i value=\"IN\">Incoming</option>\n";
    print "        <option $sel_o value=\"OUT\">Outgoing</option>\n";
    print "        </select></td>\n";
    print "    <td><input type=\"checkbox\" size=\"20\" name=\"imq_$service\"";
    print "         value=\"true\" $imq></td>";
    print "    <td><input type=\"checkbox\" size=\"20\" name=\"pmq_$service\"";
    print "         value=\"true\" $pmq></td>";
    print "    <td><input type=\"checkbox\" size=\"20\" name=\"ipmq_$service\"";
    print "         value=\"true\" $ipmq></td>";

    print "$tre\n";
  }
}

# read the selected service-configuration
# from etc/services.cfg
# -> @services_cfg

open SERVICE_CFG, "$fwdir/etc/services.cfg";
do {
    chomp ( $line = <SERVICE_CFG> );
} while ( grep !/^# THE LINES BELOW ARE AUTOMATICALLY GENERATED/, $line );
while ( <SERVICE_CFG> ) {
  if ( grep /^\s*\w+=.*$/, $_ ) {
    s/^\s*//g;
    push @services, $_;
  }
}

#
# print the results (html)
#
print "Content-type: text/html\n\n";

print_file ($fwdir . "/etc/sheets/services_cfg_head.htm");
print_file ($fwdir . "/etc/sheets/services_cfg_body.htm");
list_services (sort @services);

  opendir CFG_DIR, $cfg_dir;
  @files = grep /^[a-zA-Z]\w*\.def/, readdir CFG_DIR;
  closedir CFG_DIR;
  foreach $file (sort @files) {
    ($serv, $suffix) = split /\./, $file;
    unless ( grep /^\s*$serv=/, @services ) {
      push @file_svc, "$serv=BLOCKED\n";
    }
  }
list_services (sort @file_svc);

print_file ($fwdir . "/etc/sheets/services_cfg_end.htm");

close SERVICE_CFG;

