#!/bin/sh
# $Id: fill_service_flt.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_service_flt
# Desc: fill the service-routing form
#       with the current definitions found in etc/config/<service>.flt
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_service_flt.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:42  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:36  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:21  jens
# initial ci -r 1.0
#
#

# where is the firewall-package located ?
[ -z "$FWDIR" ] && FWDIR=`echo $0 | sed -e 's/[\/]cgi-bin[\/][A-Za-z0-9_\.-]*$//'`

if [ x$1 = x -o ! -r $FWDIR/etc/config/${1}.flt ]; then
    echo "Error: no <service> defined."
    exit 0
fi

# read the current definition
. $FWDIR/etc/config/${1}.flt

echo Content-type: text/html
echo ""

# security check
[ -e $FWDIR/etc/tmp/flt_service.htm ] && rm $FWDIR/etc/tmp/flt_service.htm
cat $FWDIR/etc/sheets/service_flt.htm | sed -e "s/#service#/$1/g" > $FWDIR/etc/tmp/flt_service.htm

for var in 1 2 3; do
  eval var_val=\$dir_$var
  case $var_val in
    IN)     rep="sel${var}_in"
        ;;
    OUT)    rep="sel${var}_out"
        ;;
    IN_OUT) rep="sel${var}_io"
        ;;
    NONE)   rep="sel${var}_none"
        ;;
  esac
   eval var_val=\$log_$var

   cat $FWDIR/etc/tmp/flt_service.htm | sed -e "s/#$rep#/ selected/g" | \
     sed -e "s/#$var#/$var_val/g" > $FWDIR/etc/tmp/flt_service_new.htm
  cp $FWDIR/etc/tmp/flt_service_new.htm $FWDIR/etc/tmp/flt_service.htm
done

sel1_none=""; sel1_in=""; sel1_out=""; sel1_io=""
sel2_none=""; sel2_in=""; sel2_out=""; sel2_io=""
sel3_none=""; sel3_in=""; sel3_out=""; sel3_io=""
sel_vars_1="sel1_none sel1_in sel1_out sel1_io"
sel_vars_2="sel2_none sel2_in sel2_out sel2_io"
sel_vars_3="sel3_none sel3_in sel3_out sel3_io"
vars="src_1 dst_1 log_1 src_2 dst_2 log_2 src_3 dst_3 log_3 $sel_vars_1 $sel_vars_2 $sel_vars_3"

for var in $vars; do
  # Hier gibts rger, wenn ein "/" in die Maske eingetragen wurde. JH
  eval var_val=\$$var
  cat $FWDIR/etc/tmp/flt_service.htm | sed -e "s/#$var#/$var_val/g" > $FWDIR/etc/tmp/flt_service_new.htm
  cp $FWDIR/etc/tmp/flt_service_new.htm $FWDIR/etc/tmp/flt_service.htm
done

cat $FWDIR/etc/tmp/flt_service.htm
rm $FWDIR/etc/tmp/flt_service.htm $FWDIR/etc/tmp/flt_service_new.htm
