#!/bin/sh
# $Id: fill_service_def.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_service_def
# Desc: fill the service definition form
#       with the current definitions
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_service_def.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:41  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:36  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:21  jens
# initial ci -r 1.0
#
#

# where is the firewall-package located ?
[ -z "$FWDIR" ] && FWDIR=`echo $0 | sed -e 's/[\/]cgi-bin[\/][A-Za-z0-9_\.-]*$//'`

if [ x$1 = x -o ! -r $FWDIR/etc/config/${1}.def ]; then
    echo "Error: no <service> defined."
    exit 0
fi

# read the current definition
. $FWDIR/etc/config/${1}.def

echo Content-type: text/html
echo ""

# security check
[ -e $FWDIR/etc/tmp/service_def.htm ] && rm $FWDIR/etc/tmp/service_def.htm
cat $FWDIR/etc/sheets/service_def.htm | sed -e "s/#service#/$1/g" > $FWDIR/etc/tmp/service_def.htm

vars_i='tcp_src_i tcp_dst_i udp_src_i udp_dst_i icmp_src_i icmp_dst_i'
vars_o='tcp_src_o tcp_dst_o udp_src_o udp_dst_o icmp_src_o icmp_dst_o'
log_i='tcp_log_i udp_log_i icmp_log_i'
log_o='tcp_log_o udp_log_o icmp_log_o'
vars="$vars_i $log_i $vars_o $log_o"

for var in $vars; do
  eval var_val=\$$var
  cat $FWDIR/etc/tmp/service_def.htm | sed -e "s/#$var#/$var_val/g" > $FWDIR/etc/tmp/service_def_new.htm
  cp $FWDIR/etc/tmp/service_def_new.htm $FWDIR/etc/tmp/service_def.htm
done

cat $FWDIR/etc/tmp/service_def.htm
rm $FWDIR/etc/tmp/service_def.htm $FWDIR/etc/tmp/service_def_new.htm
