#!/usr/bin/perl
# $Id: fill_net_cfg.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_net_cfg.cgi - Firewall Configuration Tool
# Desc: fill the Network form
#       with the current definitions
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_net_cfg.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:41  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.1  1998/10/27 21:10:37  jens
# entered into RCS
#
# Revision 1.0.9.1  1998/06/01 19:34:34  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:21  jens
# initial ci -r 1.0
#
#

# where are we located ?
$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

# the config-file
$config = "$fwdir/etc/net.cfg";

# the configuration mask html file
$html = "$fwdir/etc/sheets/net_cfg.htm";

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
    close (FILE);
  }
}

# read the configuration file
open (CFG, $config);

# skip header of config file
while (<CFG>) {
    last if /^# THE LINES BELOW/;
}

while ( <CFG> ) {
  my ($name, $value);
  # skip comments, blank lines and terminating fi line
  unless ( /^(\s*#|\s*fi\W|\s*\n)/ ) {

    # delete chars
    s/['"]//g;

    # read definitions
    ($name, $value) = split (/=/, $_);
    $name =~ s/^\s*//g;

    chomp ($Def{$name} = $value);
  }
}

$Def{"selipfwadm"}   = "";
$Def{"selipF"}       = "";
$Def{"selipchains"}  = "";
$Def{"MASQINTERNAL"} = "";
$Def{"MASQPERIMETER"}= "";
$Def{"MASQINTPERI"}  = "";

if ( $Def{"ip_cmd"} =~ /ipfwadm/ ) {
  $Def{"selipfwadm"} = "selected";
} elsif ( $Def{"ip_cmd"} =~ /ipchains/ ) {
  $Def{"selipchains"} = "selected";
} elsif ( $Def{"ip_cmd"} =~ /ipF/ ) {
  $Def{"selipF"} = "selected";
}
if ( $Def{"masquerade_internal"} =~ /true/ ) {
  $Def{"MASQINTERNAL"} = "checked";
}
if ( $Def{"masquerade_perimeter"} =~ /true/ ) {
  $Def{"MASQPERIMETER"} = "checked";
}
if ( $Def{"masqu_int_peri"} =~ /true/ ) {
  $Def{"MASQINTPERI"} = "checked";
}
close (CFG);

# fill/create the HTML configuration mask
print "Content-type: text/html\n\n";
open (HTML, $html);
while (<HTML>) {
    eval s/#(\w+)#/$Def{$1}/;
    print;
}
close (HTML);
