#!/usr/bin/perl
#
# $Id: fill_fw_cfg.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: fill_fw_cfg.cgi
# Desc: fill the 'Firewall' form
#       with the current definitions
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: fill_fw_cfg.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:41  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:23  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:33  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:20  jens
# initial ci -r 1.0
#
#
 
$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
    close (FILE);
  }
}

sub list_service {

    $sel_n=''; $sel_o=''; $sel_i=''; $sel_a='';
    if ( $dir =~ /^IN\b/ ) {
      $sel_i='selected';
    } elsif ( $dir =~ /^OUT\b/ ) {
      $sel_o='selected';
    } elsif ( $dir =~ /^IN_OUT\b/ ) {
      $sel_a='selected';
    } else {
      $sel_n='selected';
    }

    print "<tr>\n";
    print "    <td><input type=\"text\" size=\"16\" name=\"fw_service\" value=\"$service\"></td>\n";
    print "    <td><input type=\"text\" size=\"26\" name=\"fw_svc_def\" value=\"$def\"></td>\n";
    print "    <td><SELECT name=\"fw_dir\" size=\"1\">";
    print "        <OPTION $sel_n value=\"NONE\">Blocked</OPTION> <OPTION $sel_i value=\"IN\">Incoming</OPTION><OPTION $sel_o value=\"OUT\">Outgoing</OPTION>\n";
    print "        <OPTION  $sel_a value=\"IN_OUT\">All Directions</OPTION>\n";
    print "        </SELECT>\n";
    print "</tr>\n";
}


#
# print the results (html)
#
print "Content-type: text/html\n\n";

print_file ($fwdir . "/etc/sheets/fw_cfg_head.htm");

# read the selected configuration
# from etc/fw.cfg
# -> @fw_cfg

open FW_CFG, "$fwdir/etc/fw.cfg";
do {
    chomp ( $line = <FW_CFG> );
} while ( grep /^(#|\s*$)/, $line );
($key, $value) = split (/=|;/, $line);
$value =~ s/'|"//g;
$value =~ s/^\s*//g;

print " <p><font size=+1> Forbidden Hosts: <input type=\"text\"";
print " size=\"30\" name=\"deny_hosts\" value=\"$value\">\n</font><br>\n";
print "These hosts cant connect the firewall - e.g. all hosts located on the <I>perimeter network</I>.</p>\n";

print_file ($fwdir . "/etc/sheets/fw_cfg_body.htm");

while ( <FW_CFG> ) {
  if ( grep !/^(\s*#|\s*fi|\s*\n)/, $_ ) {
    ($snam, $service, $dfnam, $def, $drnam, $dir) = split (/=|;/, $_);
    if ( $snam =~ /^.*fw_service/ && $def =~ /^.+$/ ) {
      $def =~ s/'|"//g;
      list_service;
    }
  }
}
print "<tr>\n";
print "    <td><input type=\"text\" size=\"16\" name=\"fw_service\"></td>\n";
print "    <td><input type=\"text\" size=\"26\" name=\"fw_svc_def\"></td>\n";
print "    <td><SELECT name=\"fw_dir\" size=\"1\">";
print "        <OPTION selected value=\"NONE\">Blocked</OPTION> <OPTION value=\"IN\">Incoming</OPTION><OPTION value=\"OUT\">Outgoing</OPTION>\n";
print "        <OPTION value=\"IN_OUT\">All Directions</OPTION>\n";
print "        </SELECT>\n";
print "</tr>\n";

print_file ($fwdir . "/etc/sheets/fw_cfg_end.htm");

close FW_CFG;
