#!/usr/bin/perl
# $Id: create_trusted_rules.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: create_trusted_rules.cgi
# Desc: create the firewall rules for the trusted hosts
#       write rules to file 'rules/Trusted.rules'
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: create_trusted_rules.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:40  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:22  jens
# .
#
# Revision 1.1  1998/11/02 09:35:44  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.3  1998/06/14 10:47:23  jens
# display trusted hosts
#
# Revision 1.0.9.2  1998/06/02 18:00:40  jens
# *** empty log message ***
#
# Revision 1.0.9.1  1998/06/01 19:34:33  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:20  jens
# initial ci -r 1.0
#
#

print "Content-type: text/plain\n\n";

$fwdir = `pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);
$|=1;

open ( TRUSTED, "$fwdir/etc/trusted.cfg" );
while ( <TRUSTED> ) {
  if ( /^trusted_host=(.+);.*_dev/ ) {
    $host = $1; $host =~ s/'//g;
    push @host, $host;
  }
  if ( /trusted_dev=(.*);.*_fw/ ) {
    $dev = $1; $dev =~ s/'//g;
    push @dev,  $dev;
  }
  if ( /trusted_fw=(.*);.*_log/ ) {
    $fw = $1; $fw =~ s/'//g;
    push @fw,  $fw;
  }
  if ( /trusted_log=(.*)\n/ ) {
    $log = $1; $log =~ s/'//g;
    push @log,  $log;
  }
}
close ( TRUSTED );

unlink "$fwdir/rules/Trusted.rules" if -e "$fwdir/rules/Trusted.rules";
open (TH, ">$fwdir/rules/Trusted.rules");

print TH <<EOF;
#!/bin/sh
#
# File: rules/Trusted.rules - Firewall Configuration Tool
# Desc: this script sets up your firewall rules for
#       external "trusted" IPs on specific devices
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich

# where is the firewall-package located ?
[ -z "\$FWDIR" ] && FWDIR=\`echo \$0 | sed -e 's/[\\/]rules[\\/][A-Za-z0-9_\\.-]*\$//'\`

# default behaviour is 'add'
mod=add
[ "x\$1" = xdel ] && mod=del
[ "x\$1" = xins ] && mod=ins
imod=ins; [ "\$mod" = del ] && imod=del

# logfile for setup
setup_file=Trusted.rules

. \$FWDIR/etc/net.cfg
. \$FWDIR/etc/aliases.cfg
. \$FWDIR/etc/gateway.sh

EOF

while ( @host ) {
  $host = shift @host; $dev = shift @dev; $fw = shift @fw; $log = shift @log;
  $mod=mod; $iplog="";
  $fwtxt="";
  if ( $fw =~ /checked/ ) {
    $mod=imod;
    $fwtxt="++firewall++";
  }
  if ( $log =~ /checked/ ) {
    $iplog="log";
  }
print TH <<EOF;
#printf "echo '#--- %7s: %s ---'\\n" "$dev" \"$fwtxt $host $iplog\"
printf "#--- %7s: %s ---\\n" "$dev" \"$fwtxt $host $iplog\"
for host in $host; do
  tipgw \$$mod \$host $dev $iplog
done

EOF
}

close ( TH );

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
    close (FILE);
  }
}

print_file ("$fwdir/rules/Trusted.rules");

