#!/bin/sh
# $Id: create_service_rules.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: create_service_rules.cgi
# Desc: create the rules for the specified service
#       write rules to file 'rules/<service>.rules'
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: create_service_rules.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:39  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:22  jens
# .
#
# Revision 1.1  1998/11/02 09:35:43  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.1  1998/10/30 14:27:37  jens
# entered into RCS
#
# Revision 1.0.9.2  1998/06/02 18:00:30  jens
# *** empty log message ***
#
# Revision 1.0.9.1  1998/06/01 19:34:33  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:20  jens
# initial ci -r 1.0
#
#

# where is the firewall-package located ?
[ -z "$FWDIR" ] && FWDIR=`echo $0 | sed -e 's/[\/]cgi-bin[\/][a-zA-Z0-9_\.-]*$//'`

# a <service> must be defined
if [ x$1 = x  -o ! -r $FWDIR/etc/config/${1}.def -o ! -r $FWDIR/etc/config/${1}.flt ]; then
    echo "FWDIR = $FWDIR"
    echo "Error: the <service> must be defined!"
    exit 1
fi

# default option is 'add'
mod=add
[ x$2 != xadd ] && mod=del

RULES=$FWDIR/rules/${1}.rules

[ -r $FWDIR/etc/net.cfg ]      && . $FWDIR/etc/net.cfg
[ -r $FWDIR/etc/aliases.cfg ]  && . $FWDIR/etc/aliases.cfg
[ -r $FWDIR/etc/services.cfg ] && . $FWDIR/etc/services.cfg

. $FWDIR/etc/config/${1}.def
. $FWDIR/etc/config/${1}.flt

echo Content-type: text/plain
echo ""

[ -e $RULES ] && rm $RULES
cat > $RULES <<EOF
#!/bin/sh
#
# File: rules/${1}.rules - Firewall Configuration Tool
# Desc: this script sets up your firewall rules for
#       the specified service
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich

# where is the firewall-package located ?
[ -z "\$FWDIR" ] && FWDIR=\`echo \$0 | sed -e 's/[\/]rules[\/][A-Za-z0-9_\.-]*\$//'\`

# default option is 'add'
mod=add
[ "x\$1" = xdel ] && mod=del
[ "x\$1" = xins ] && mod=ins

# logfile for setup
setup_file=${1}.rules

. \$FWDIR/etc/net.cfg
. \$FWDIR/etc/aliases.cfg
. \$FWDIR/etc/gateway.sh
. \$FWDIR/etc/services.cfg

# check masquerading
imq="\$imq_${1}"
pmq="\$pmq_${1}"
ipmq="\$ipmq_${1}"

EOF

# --------------------
# Filtering-Rules loop
# --------------------
for flt_nr in 1 2 3; do
  eval dest_data=\$dst_$flt_nr
  eval source_data=\$src_$flt_nr
  eval dir_data=\$dir_$flt_nr
  eval log_data=\$log_$flt_nr

  close_for=true
  close_if=true

  echo >> $RULES "# -------------------"
  echo >> $RULES "# Ruleset nr. $flt_nr"
  echo >> $RULES "# -------------------"

  # ----------------
  # Destination loop
  # ----------------

    dhost="$dest_data"

    # -----------
    # Source loop
    # -----------

     shost="$source_data"
   
     if [ -n "$shost" -a -n "$dhost" ]; then

      if [ $dir_data = OUT -o $dir_data = IN_OUT ]; then
        # ---------------------------------
        # Protocol loop ( TCP, UDP, ICMP )
        # ---------------------------------
        for proto in tcp udp icmp; do

          ack=''; [ $proto = tcp ] && ack='ack'

          eval port_s_o="\$${proto}_src_o"; eval port_d_o="\$${proto}_dst_o"
          eval log_o="\$${proto}_log_o"

          eval port_s_i="\$${proto}_src_i"; eval port_d_i="\$${proto}_dst_i"
          eval log_i="\$${proto}_log_i"

          eval port_src_i="\"$port_s_i\""; eval port_dst_i="\"$port_d_i\""
          eval port_src_o="\"$port_s_o\""; eval port_dst_o="\"$port_d_o\""

          # ------------------------------
          # loops over each Protocol port
          # ------------------------------

          # --- source ports outgoing ---
          i=0
          for port in $port_src_o; do
            i=`expr $i + 1`
            log=""
            [ -n "$log_data" ] && log="log"
            [ $i -eq 1 -a -n "$log_o" ] && log="log"
            [ $proto = icmp ] && port_dst_o="any"
            port_s=$port
            port_d=`echo "$port_dst_o" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Outgoing:"
                echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = OUT ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipgw  \$mod $acc -O \$source \$dest   $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipgw  \$mod $acc -O \$source \$dest   $port_s $port_d $proto $log"
              [ "$proto" = tcp ] && \
                  echo >> $RULES \
                  "    ipgw  \$mod $acc -I \$dest   \$source $port_d $port_s $proto ack"
            fi
          done
          
          # --- source ports incoming ---
          i=0
          for port in $port_src_i; do
            i=`expr $i + 1`
            log=""
            [ -n "$log_data" ] && log="log"
            [ $i -eq 1 -a -n "$log_i" ] && log="log"
            [ $proto = icmp ] && port_dst_i="any"
            port_s=$port
            port_d=`echo "$port_dst_i" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Outgoing:"
                echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = OUT ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipgw  \$mod $acc -I \$dest   \$source $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipgw  \$mod $acc -I \$dest   \$source $port_s $port_d $proto $log"
              [ "$proto" = tcp ] && \
                  echo >> $RULES \
                  "    ipgw  \$mod $acc -O \$source \$dest   $port_d $port_s $proto ack"
            fi
          done
        done
        echo >> $RULES ""
        [ $close_if = false ] && echo >> $RULES "  fi"
        close_if=true
      fi
      
      if [ $dir_data = IN -o $dir_data = IN_OUT ]; then
        # --------------
        # Protokoll loop
        # --------------
        for proto in tcp udp icmp; do

        eval port_s_i="\$${proto}_src_i"; eval port_d_i="\$${proto}_dst_i"
        eval log_i="\$${proto}_log_i"

        eval port_s_o="\$${proto}_src_o"; eval port_d_o="\$${proto}_dst_o"
        eval log_o="\$${proto}_log_o"

        eval port_src_i="\"$port_s_i\""; eval port_dst_i="\"$port_d_i\""
        eval port_src_o="\"$port_s_o\""; eval port_dst_o="\"$port_d_o\""

        # -----------
        # Port loops
        # -----------
          i=0
          for port in $port_src_o; do
            i=`expr $i + 1`
            log=""
            [ -n "$log_data" ] && log="log"
            [ $i -eq 1 -a -n "$log_o" ] && log="log"
            [ $proto = icmp ] && port_dst_o="any"
            port_s=$port
            port_d=`echo "$port_dst_o" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Incoming:"
                echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = IN ]; then'; close_if=false
              fi
              echo >> $RULES "" 
              if [ -n "$log" ]; then 
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipgw \$mod $acc -I \$dest   \$source $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipgw \$mod $acc -I \$dest   \$source $port_s $port_d $proto $log"
              [ $proto = tcp ] && \
                echo >> $RULES \
                "    ipgw  \$mod $acc -O \$source \$dest   $port_d $port_s $proto ack"
            fi
          done
          
          i=0
          for port in $port_src_i; do
            i=`expr $i + 1`
            log=""
            [ -n "$log_data" ] && log="log"
            [ $i -eq 1 -a -n "$log_i" ] && log="log"
            [ $proto = icmp ] && port_dst_i="any"
            port_s=$port
            port_d=`echo "$port_dst_i" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Incoming:"
                echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = IN ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then 
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipgw \$mod $acc -O \$source \$dest   $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipgw \$mod $acc -O \$source \$dest   $port_s $port_d $proto $log"
              [ $proto = tcp ] && \
                echo >> $RULES \
                "    ipgw  \$mod $acc -I \$dest   \$source $port_d $port_s $proto ack"
            fi
          done
        done
        echo >> $RULES ""
        [ $close_if = false ] && echo >> $RULES "  fi"
        close_if=true
      fi
     fi
   echo >> $RULES ""
   [ $close_for = false ] && echo >> $RULES " done"
  [ $close_for = false ] && echo >> $RULES "done"; close_for=true
  echo >> $RULES ""
done # rules loop

cat $RULES
