#!/bin/sh
# $Id: create_fw_rules.sh,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: create_fw_rules.sh
# Desc: write firewall-service rules
#       to file 'rules/Firewall/<service>.rules'
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: create_fw_rules.sh,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:35  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:22  jens
# .
#
# Revision 1.1  1998/11/02 09:35:43  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:23  jens
# Initial revision
#
# Revision 1.0.9.1  1998/06/01 19:34:33  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:20  jens
# initial ci -r 1.0
#
#

# where is the firewall-package located ?
[ -z "$FWDIR" ] && FWDIR=`echo $0 | sed -e 's/[\/]cgi-bin[\/][A-Za-z0-9_\.-]*$//'`

RULES=$FWDIR/rules/Firewall/${1}.rules

if [ ! -f $RULES ]; then
cat > $RULES <<EOF
#!/bin/sh
# \$Id\$
# \$Date\$
#
# File: rules/Firewall/${1}.rules - Firewall Configuration Tool
# Desc: rules for ${1} on the firewall
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich

# where is the firewall-package located ?
[ -z "\$FWDIR" ] && FWDIR=\`echo \$0 | sed -e 's/[\/]rules[\/]Firewall[\/][A-Za-z0-9_\.-]*\$//'\`

# default option is 'add'
mod=add; [ "x\$1" = xdel ] && mod=del

# logfile for setup
setup_file=Firewall/${1}.rules

. \$FWDIR/etc/net.cfg 
. \$FWDIR/etc/aliases.cfg 
. \$FWDIR/etc/gateway.sh

EOF
fi

[ -r $FWDIR/etc/net.cfg ]      && . $FWDIR/etc/net.cfg
[ -r $FWDIR/etc/aliases.cfg ]  && . $FWDIR/etc/aliases.cfg

. $FWDIR/etc/config/${1}.def

  close_for=true
  close_if=true

  for sh in $FW; do
    shost=$sh
    eval dhost="$2"
    
    if [ $3 = OUT -o $3 = IN_OUT ]; then
        # ---------------------------------
        # Protocol loop ( TCP, UDP, ICMP )
        # ---------------------------------
        for proto in tcp udp icmp; do

          ack=''; [ $proto = tcp ] && ack='ack'
          eval port_s_i="\$${proto}_src_i"; eval port_d_i="\$${proto}_dst_i"
          eval log_i="\$${proto}_log_i"

          eval port_s_o="\$${proto}_src_o"; eval port_d_o="\$${proto}_dst_o"
          eval log_o="\$${proto}_log_o"

          eval port_src_i="\"$port_s_i\""; eval port_dst_i="\"$port_d_i\""
          eval port_src_o="\"$port_s_o\""; eval port_dst_o="\"$port_d_o\""

          # ------------------------------
          # loops over each Protocol port
          # ------------------------------

          # --- source ports outgoing ---
          i=0
          for port in $port_src_o; do
            i=`expr $i + 1`;
            log=""
            [ $i -eq 1 -a -n "$log_o" ] && log="log"
            [ $proto = icmp ] && port_dst_o="any"
            port_s=$port
            port_d=`echo "$port_dst_o" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Outgoing:"
                #echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = OUT ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipfw \$mod $acc -O \$source \$dest   $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipfw \$mod $acc -O \$source \$dest   $port_s $port_d $proto $log"
              [ "$proto" = tcp ] && \
                  echo >> $RULES "    ipfw \$mod $acc -I \$dest   \$source $port_d $port_s $proto ack"
            fi
          done

          # --- source ports incoming ---
          i=0
          for port in $port_src_i; do
            i=`expr $i + 1`
            log=""
            [ $i -eq 1 -a -n "$log_i" ] && log="log"
            [ $proto = icmp ] && port_dst_i="any"
            port_s=$port
            port_d=`echo  "$port_dst_i" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi

            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Outgoing:"
                #echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = OUT ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipfw \$mod $acc -I \$dest   \$source $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipfw \$mod $acc -I \$dest   \$source $port_s $port_d $proto $log"
              [ "$proto" = tcp ] && \
                  echo >> $RULES "    ipfw \$mod $acc -O \$source \$dest   $port_d $port_s $proto ack"
            fi
          done
        done
        echo >> $RULES ""
        [ $close_if = false ] && echo >> $RULES "  fi"
        close_if=true
      fi

      if [ $3 = IN -o $3 = IN_OUT ]; then
        # --------------
        # Protokoll loop
        # --------------
        for proto in tcp udp icmp; do

        eval port_s_i="\$${proto}_src_i"; eval port_d_i="\$${proto}_dst_i"
        eval log_i="\$${proto}_log_i"

        eval port_s_o="\$${proto}_src_o"; eval port_d_o="\$${proto}_dst_o"
        eval log_o="\$${proto}_log_o"

        eval port_src_i="\"$port_s_i\""; eval port_dst_i="\"$port_d_i\""
        eval port_src_o="\"$port_s_o\""; eval port_dst_o="\"$port_d_o\""

        # -----------
        # Port loops
        # -----------
          i=0
          for port in $port_src_o; do
            i=`expr $i + 1`
            log=""
            [ $i -eq 1 -a -n "$log_o" ] && log="log"
            [ $proto = icmp ] && port_dst_o="any"
            port_s=$port
            port_d=`echo "$port_dst_o" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Incoming:"
                #echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = IN ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipfw \$mod $acc -I \$dest   \$source $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipfw \$mod $acc -I \$dest   \$source $port_s $port_d $proto $log"
              [ $proto = tcp ] && \
                echo >> $RULES \
                "    ipfw \$mod $acc -O \$source \$dest   $port_d $port_s $proto ack"
            fi
          done

          i=0
          for port in $port_src_i; do
            i=`expr $i + 1`
            log=""
            [ $i -eq 1 -a -n "$log_i" ] && log="log"
            [ $proto = icmp ] && port_dst_i="any"
            port_s=$port
            port_d=`echo "$port_dst_i" | cut -f $i -d " "`
            acc=accept
            if [ `echo "$port_s $port_d" | grep -c '!'` -gt 0 ]; then
              acc=deny
              port_s=`echo $port_s | tr -d '!'`
              port_d=`echo $port_d | tr -d '!'`
            fi
            if [ "x$port_s" != x  -a "x$port_d" != x ]; then
              if [ $close_for = true ]; then
                echo >> $RULES "for dest in $dhost; do"; close_for=false
                echo >> $RULES " for source in $shost; do"
              fi
              if [ $close_if = true ]; then
                echo >> $RULES ""
                echo >> $RULES "  # Incoming:"
                #echo >> $RULES '  if [ "$'$1'" = FILTERED -o "$'$1'" = IN ]; then'; close_if=false
              fi
              echo >> $RULES ""
              if [ -n "$log" ]; then
                if [ "$proto" = tcp ]; then
                  echo >> $RULES "    ipfw \$mod $acc -O \$source \$dest   $port_s $port_d $proto log"
                  log=""
                fi
              fi
              echo >> $RULES     "    ipfw \$mod $acc -O \$source \$dest   $port_s $port_d $proto $log"
              [ $proto = tcp ] && \
                echo >> $RULES \
                "    ipfw \$mod $acc -I \$dest   \$source $port_d $port_s $proto ack"
            fi
          done
        done
        echo >> $RULES ""
        [ $close_if = false ] && echo >> $RULES "  fi"
        close_if=true
      fi
   echo >> $RULES ""
   [ $close_for = false ] && echo >> $RULES " done"
  [ $close_for = false ] && echo >> $RULES "done"; close_for=true
  echo >> $RULES ""

  done # for shost in $FW
