#!/usr/bin/perl
# $Id: create_fw_rules.cgi,v 1.1.5.1 2000/07/16 11:59:51 root Exp root $
# $Date: 2000/07/16 11:59:51 $
#
# File: create_fw_rules.cgi
# Desc: write the firewall-rules
#       to the rules-file 'rules/Firewall.rules'
#
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich
#
# $Log: create_fw_rules.cgi,v $
# Revision 1.1.5.1  2000/07/16 11:59:51  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:00:22  jens
# *** empty log message ***
#
# Revision 1.1.4.1  1999/08/01 21:44:44  jens
# .
#
# Revision 1.1  1999/08/01 21:44:44  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:22  jens
# .
#
# Revision 1.1  1998/11/02 09:35:43  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:22  jens
# Initial revision
#
# Revision 1.0.9.2  1998/06/02 17:57:11  jens
# enable loging in rules-files
#
# Revision 1.0.9.1  1998/06/01 19:34:32  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:20  jens
# initial ci -r 1.0
#
#

$fwdir=`pwd`;
$fwdir =~ s/\/cgi-bin//;
chomp ($fwdir);
$|=1;

# read the configuration file
$config = "$fwdir/etc/fw.cfg";

# create the rules file
$rules = "$fwdir/rules/Firewall.rules";
unlink $rules if -e $rules;
open (RULES, ">$rules");

print "Content-type: text/plain\n\n";

print RULES <<EOF;
#!/bin/sh
#
# File: rules/Firewall.rules - Firewall Configuration Tool
# Desc: filtering rules for the firewall host
# 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 J. Friedrich

# where is the firewall-package located ?
[ -z "\$FWDIR" ] && FWDIR=\`echo \$0 | sed -e 's/[\\/]rules[\\/][A-Za-z0-9_\\.-]*\$//'\`

. \$FWDIR/etc/net.cfg
. \$FWDIR/etc/aliases.cfg
. \$FWDIR/etc/gateway.sh

# default option is 'add'
mod=add
[ "x\$1" = xdel ] && mod=del
[ "x\$1" = xins ] && mod=ins
ipmod=-a
[ "\$mod" = del ] && ipmod=-d
[ "\$mod" = ins ] && ipmod=-i
ipimod=-i; [ "\$mod" = del ]  && ipimod=-d

# logfile for setup
setup_file=Firewall.rules

HOST=`hostname -s`

# First, we set up some security for my IPs:
# 1. My IPs arent comming in from the interface connected
#    to the internet!
# 2. Setup the Services on the Firewall

EOF

open (CFG, "$config");
while (<CFG>) {
  last if /^deny_hosts=/;
}
($dummy, $denied) = split(/=/, $_);
$denied =~ s/['"\n]//g;

print RULES <<EOF;

echo "#--- allow firewall to connect himself ---"
# allow all for loopback interface (localhost)
for loopbk in localhost \$HOST \$FW; do
    \$IPFW -I \$ipmod accept "" \$loopbk "" \$loopbk "" "" lo
    \$IPFW -O \$ipmod accept "" \$loopbk "" \$loopbk "" "" lo
done

EOF

if ( $denied =~ /^.+/ ) {
print RULES <<EOF;
#
# some hosts are not allowed to connect the firewall
#
echo "#--- deny firewall for some hosts ---" | tee -a \$FWDIR/log/\$ip_cmd.log
for fw in \$FW; do
  for host in $denied; do
    \$IPFW -I \$ipmod deny "" \$host "" \$fw   "" "" ""
    \$IPFW -O \$ipmod deny "" \$fw   "" \$host "" "" ""
  done
done

EOF
}

print RULES <<EOF;
#
# Each <service> follows below ...
#
EOF

#
# create the service entries in rules/Firewall/<service>.rules
#
unlink <$fwdir/rules/Firewall/*.rules>;
$last_service="";
while (<CFG>) {
  /^fw_service=(\w+);\s+fw_svc_def=['"]?(.*)['"]?;\s*fw_svc_dir=(\w+).*$/;
  ($service, $def, $dir) = ($1, $2, $3);
  $def =~ s/['"\n]//g;
  $_ = $last_service;
  if ( ! /^$service$/ ) {
    print RULES "\n\nprintf \"#--- $service ---\\n\" | tee -a \$FWDIR/log/\$ip_cmd.log\n";
    print RULES ". \$FWDIR/rules/Firewall/$service.rules \$mod\n";
  }
  print RULES "# $service: $dir  $def\n";
 
  system ("$fwdir/cgi-bin/create_fw_rules.sh" ,"$service", "\"$def\"", "$dir");
  
  $last_service = $service;
}

print RULES <<EOF;

#
# deny everything else from/to the firewall
#
echo "#--- deny everything else from/to the firewall ---"
for fw in \$HOST \$FW; do
    \$IPFW -I \$ipmod deny "" ""  "" \$fw "" "" "" -q
    \$IPFW -O \$ipmod deny "" \$fw "" ""  "" "" "" -q
done

EOF

close (CFG);
close (RULES);

sub print_file {
  foreach $file (@_) {
    open (FILE, "$file");
    while (<FILE>) {
      print ;
    }
    close (FILE);
  }
}

print_file ("$rules");
