#!/bin/sh
# $Id: Install.sh,v 1.1.5.1 2000/07/16 12:00:02 root Exp root $
# $Date: 2000/07/16 12:00:02 $
#
# File: Install.sh
# Desc: Installation of the Firewall Configuration Tool
#
# Author : Jens Friedrich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# (c) Copyright 1998 Jens Friedrich
#
# $Log: Install.sh,v $
# Revision 1.1.5.1  2000/07/16 12:00:02  root
# FCT
#
# Revision 1.1.4.2  2000/07/15 19:01:24  jens
# Rev.
#
# Revision 1.1.4.1  1999/08/01 21:44:55  jens
# .
#
# Revision 1.1  1999/08/01 21:44:55  jens
# Initial revision
#
# Revision 1.1.0.1  1998/11/02 09:36:30  jens
# .
#
# Revision 1.1  1998/11/02 09:35:49  jens
# Initial revision
#
# Revision 1.1  1998/11/02 09:33:28  jens
# Initial revision
#
# Revision 1.1  1998/10/12 18:05:00  jens
# entered into RCS
#
# Revision 1.0.9.2  1998/06/14 10:51:36  jens
# inserted cgi-bin/.htaccess
#
# Revision 1.0.9.1  1998/06/01 19:35:24  jens
# initial ci -r 1.0.9
#
# Revision 1.0  1998/06/01 19:32:58  jens
# initial ci -r 1.0
#
#

# owner/group to install FCT
owner=root
group=root

# executables
exe='accounting firewall fw_rules reset save_config create_rules cgi-bin/*'
exe="$exe rules/* rules/Firewall/* Install.sh"
exe2="syslog.filter deny_cmds"

# dirs/files read by HTTP-Server
http_dirs='cgi-bin etc etc/config etc/cfg_header etc/sheets html log rules rules/Firewall'
http_files='firewall index.html cgi-bin/*.* etc/*.sh etc/config/*.* etc/cfg_header/*.* etc/sheets/*.* html/*.* FAQ'
http_exe='accounting firewall fw_rules reset save_config cgi-bin/*.*'

# dirs modified by HTTP-Server
mod_dirs='etc/config log rules rules/Firewall etc/tmp'

# files modified by HTTP-Server
mod_files='etc/*.cfg etc/config/*.def etc/config/*.flt log/* rules/* rules/Firewall/*'

for dir in $mod_dirs $http_dirs; do
    [ -e "$dir" ] || mkdir $dir
done

usage ()
{
    echo ""
    echo "Usage: $0 [-cgi] [-strict] [userid]"
    echo ""
    echo "$0 -strict -cgi    installs FCT with cgi and minimum of acces rights."
    echo ""
    echo "-cgi       enable cgi-option/access-rights for httpd"
    echo "-strict    restrict acces rights"
    echo "userid     userid for modified files (e.g. wwwrun)"
    echo "           default: result from whoami"
    echo ""
    exit 1
}

cd `dirname $0`

# check for perl 
if [ ! -x /usr/bin/perl ]; then
    cat << EOF
Error: missing perl in directory /usr/bin/perl
       please insert a link from /usr/bin/perl to your perl binary
EOF
fi

# OS dependent things
unix=`uname`
case "$unix" in
    Linux)
              ps_opt=-ef
              #ps_opt=aux
              who=`whoami`
              ;;
    *)
              ps_opt=-ef
              who=`id | cut -d"(" -f2 | cut -d")" -f1`
              ;;
esac

#------------------------------
# get userid
# -cgi gets uid of httpd
#------------------------------
uid=""
ans=""
cgi="false"
strict=false

while [ "$#" -gt 0 ]; do
    case "$1" in
        -h) usage
            ;;
        -cgi)
            cgi=true
            ;;
        -strict)
            if [ "$who" != root ]; then 
                echo "Must be root to do this."
                exit 1
            fi
            strict=true
            ;;
        *)
            uid="$1"
            ans="y"
            ;;
    esac
    shift
done

# default uid, whithout -cgi option
[ "$cgi" = false -a -z "$uid" ] && uid=$who

# force checking httpd uid
[ "$strict" = true -a -z "$uid" ] && ans="n"

# try to get httpd-id with `ps`
if [ -z "$uid" ]; then
    uid=`ps $ps_opt | grep -v grep | grep http | sort -r | head -1 | cut -f1 -d" "`
#    uid=root
    ans=y
fi

# check httpd uid
until [ "$ans" = "" -o "$ans" = y -o "$ans" = Y ]; do
    if [ "$uid" = "" ]; then
	echo "Cant get the userid of your HTTP-Server."
	echo -n "Whats the correct userid ? "
	read uid
    fi
    echo    "The userid of the HTTP-Server is '$uid'."
    echo -n "Is this correct [Y/n] ? "
    read ans
    [ "$ans" = "" -o "$ans" = y -o "$ans" = Y ] || uid=""
done

#------------------------------
# set access rights for FCT ...
#------------------------------
echo "setting access rights for userid $uid ..."

# opt strict limits user/other access
if [ "$strict" = true ]; then
    chown -R $owner .
    chgrp -R $group .
    chmod -R 660 .
    find . -type d -exec chmod g+x \{\} \;
else
    find . -type d -exec chmod u+x \{\} \;
fi

# check all executables ...
for e2 in $exe2; do
    [ -r "$e2" ] && exe="$exe $e2"
done

# exe rights
if [ "$strict" = true ]; then
    chmod g+x $exe
else
    chmod u+x $exe
fi

# HTTP-Server rights
if [ "$cgi" = true ]; then
    if [ "$strict" = true ]; then
        chmod a+rx    .
        chown $uid    $mod_dirs $mod_files $http_dirs $http_exe $http_files
        chmod u+x     $mod_dirs            $http_dirs $http_exe
        chmod u+w     $mod_dirs $mod_files
    else
        chmod a+r     $mod_dirs $mod_files $http_dirs $http_exe $http_files
        chmod a+x     $mod_dirs            $http_dirs $http_exe
        chmod a+w     $mod_dirs $mod_files
    fi
else
    chmod u+r     $mod_dirs $mod_files $http_dirs $http_exe $http_files
    chmod u+x     $mod_dirs            $http_dirs $http_exe
    chmod u+w     $mod_dirs $mod_files
fi
