#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 2000 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-boot-check functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

no_result()
{
	set +x
	echo 'NO RESULT for test of the dns-boot-check functionality' 1>&2
	cd $here
	rm -rf $work
	exit 2
}
fail()
{
	set +x
	echo 'FAILED test of the dns-boot-check functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-boot-check functionality
#
mkdir etc var var/named
if test $? -ne 0 ; then no_result; fi

cat > etc/named.boot << 'fubar'
; Linux Network Administrators Guide
; Example 6-2, page 85
;
directory	/var/named
;
;		domain			file
;-------------------
cache		.			named.ca
primary		vbrew.com.		named.hosts
primary		0.0.127.in-addr.arpa.	named.local
primary		16.172.in-addr.arpa.	named.rev

fubar
if test $? -ne 0 ; then no_result; fi

cat > var/named/named.ca << 'fubar'
; Linux Network Administrators Guide
; Example 6-3, page 91
;
.		99999999 in	ns	ns.nic.ddn.mil
ns.nic.ddn.mil	99999999 in	a	23.3.0.103
.		99999999 in	ns	ns.nasa.gov
ns.nasa.gov	99999999 in	a	128.102.16.10

fubar
if test $? -ne 0 ; then no_result; fi

cat > var/named/named.hosts << 'fubar'
; Linux Network Administrators Guide
; Example 6-4, page 91
;
@		in	 soa	vlager.vbrew.com. janet.vbrew.com. (
					16	; serial
					86400	; refresh
					3600	; retry
					3600000	; expire
					604800 ) ; minimum
		in	ns	vlager.vbrew.com.
		in	mx	10 vlager
localhost.	in	a	127.0.0.1
vlager		in	a	172.16.1.1
vlager-if1	in	cname	vLager
news		in	cname	vlager
vstout		in	a	172.16.1.2
vale		in	a	172.16.1.3
vlager-if2	in	a	172.16.2.1
vbarDolino	in	a	172.16.2.2
vchianti	in	a	172.16.2.3
vbeaujolais	in	a	172.16.2.4

fubar
if test $? -ne 0 ; then no_result; fi

cat > var/named/named.local << 'fubar'
; Linux Network Administrators Guide
; Example 6-5, page 92
;
@		in	soa	vlager.vbrew.com. joe.vbrew.com. (
					1	; serial
					360000	; refresh
					3600	; retry
					3600000	; expire
					360000	; minimum
					)
		in	ns	vlager.vbrew.com.
1		in	ptr	localhost.
fubar
if test $? -ne 0 ; then no_result; fi

cat > var/named/named.rev << 'fubar'
; Linux Network Administrators Guide
; Example 6-6, page 92
;
@		in	soa	vlager.vbrew.com. joe.vbrew.com. (
					1	; serial
					86400	; refresh
					3600	; retry
					3600000	; expire
					604800	; minimum
					)
		in	ns	vlager.vbreW.com.
1.1		in	ptr	vlager.vbrew.com.
2.1		in	ptr	Vstout.vbrew.com.
3.1		in	ptr	vale.vbrew.com.
1.2		in	ptr	vlager-if2.vbrew.com.
2.2		in	ptr	vbardolino.vbrew.com.
3.2		in	ptr	vchianti.vbrew.com.
4.2		in	ptr	vbeaujolais.vbrew.com.
fubar
if test $? -ne 0 ; then no_result; fi

$bin/dns-boot-check -I. etc/named.boot > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
