#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 2000 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the IN LOC functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the IN LOC functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the IN LOC functionality
#
cat > test.in << 'fubar'
; Examples taken from RFC1876
$origin example.
@		in	soa	example. hostmaster.example. (
			;	YYYYMMDDnn
				1992100601 ; serial
				10800	; refresh	3 hours
				1800	; retry		30 minutes
				3600000	; expire	1000 hours
				86400 )	; minimum	24 hours
;;;
;;; note that these data would not all appear in one zone file
;;;

;; network LOC RR derived from ZIP data.  note use of precision defaults
cambridge-net.kei.com.     IN LOC   42 21 54 N 71 06 18 W -24m 30m

;; higher-precision host LOC RR.  note use of vertical precision default
loiosh.kei.com.            IN LOC   42 21 43.952 N 71 5 6.344 W -24m 1m 200m

pipex.net.                 IN LOC   52 14 05 N 00 08 50 E 10m
curtin.edu.au.             IN LOC   32 7 19 S 116 2 25 E 10m
rwy04L.logan-airport.boston. in LOC   42 21 28.764 N 71 00 51.617 W -44m 2000m
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
$origin example.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 3 "test.in"
@		in	soa	example. hostmaster.example. (
				1992100601	; serial
				10800	; refresh: 3 hours
				1800	; retry: 30 minutes
				3600000	; expire: 5 weeks, 6 days, 16 hours
				86400 )	; minimum: 1 day






cambridge-net.kei.com. in loc	( 42 21 54 N	; latitude
				71 6 18 W	; longitude
				-24.0m		; altitude
				30.0m		; error size
				10000m		; horizontal precision
				10.0m	)	; vertical precision
$line 18 "test.in"
loiosh.kei.com.	in	loc	( 42 21 43.952 N	; latitude
				71 5 6.344 W	; longitude
				-24.0m		; altitude
				1.00m		; error size
				200m		; horizontal precision
				10.0m	)	; vertical precision
$line 20 "test.in"
pipex.net.	in	loc	( 52 14 5 N	; latitude
				0 8 50 E	; longitude
				10.0m		; altitude
				1.00m		; error size
				10000m		; horizontal precision
				10.0m	)	; vertical precision
$line 21 "test.in"
curtin.edu.au.	in	loc	( 32 7 19 S	; latitude
				116 2 25 E	; longitude
				10.0m		; altitude
				1.00m		; error size
				10000m		; horizontal precision
				10.0m	)	; vertical precision
$line 22 "test.in"
rwy04L.logan-airport.boston. in loc ( 42 21 28.764 N	; latitude
				71 0 51.617 W	; longitude
				-44.0m		; altitude
				2000m		; error size
				10000m		; horizontal precision
				10.0m	)	; vertical precision
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter test.in test.out 2> test.err
if test $? -ne 0 ; then cat test.err; fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
