#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-hosts-import functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the dns-hosts-import functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-hosts-import functionality
#
cat > test.in << 'fubar'
182.168.1.1	mercury
182.168.1.2	venus
182.168.1.3	earth
182.168.1.4	mars
182.168.1.5	jupiter
182.168.1.6	saturn
182.168.1.7	neptune
182.168.1.8	uranus
182.168.1.9	pluto lp
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
$origin example.com.
@		in	soa	example.com. hostmaster.example.com. (
				3	; serial
				10800	; refresh: 3 hours
				1800	; retry: 30 minutes
				604800	; expire: 1 week
				86400 )	; minimum: 1 day
mercury		in	a	182.168.1.1
venus		in	a	182.168.1.2
earth		in	a	182.168.1.3
mars		in	a	182.168.1.4
jupiter		in	a	182.168.1.5
saturn		in	a	182.168.1.6
neptune		in	a	182.168.1.7
uranus		in	a	182.168.1.8
pluto		in	a	182.168.1.9
lp		in	cname	pluto
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-hosts-import -d=example.com test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
