#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-ng functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the dns-ng functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-ng functionality
#
cat > test.in << 'fubar'
$origin example.com.
@	in	soa	exmaple.com. hostmaster.example.com. (
			990101001	; serial
			10800		; refresh: 3 hours
			1800		; retry: 30 minutes
			3600000		; expire: 1000 hours
			86400 )		; minimum: 24 hours
mercury	in	a	182.168.1.1
	ether	a	2:7:1:f:b7:fb
	in	hinfo	"IBM-PC 486" "MSDOS"
venus	in	a	182.168.1.2
	ether	a	2:60:8c:2d:20:c4
	in	hinfo	"IBM-6000/590" "UNIX AIX 3.2.5"
earth	in	a	182.168.1.3
	ether	a	08:00:20:79:1f:0d
	in	hinfo	"Sun-4/5 (SPARCstation 5)" "UNIX SunOS 5.4"
mars	in	a	182.168.1.4
	ether	a	aa:0:4:0:86:53
	in	hinfo	"DEC-Alpha 3000" "UNIX OSF/1 V3.2"
jupiter	in	a	182.168.1.5
	ether	a	8:0:2b:99:49:ad
	in	hinfo	"DEC-VXT2000+ XTerminal" "Other: X11R5"
	bootp	tc	dec-vxt-2000
saturn	in	a	182.168.1.6
	ether	a	0:40:10:56:43:57
	in	hinfo	"Apple-Macintosh IIsi" "MacOS 7.5.3"
neptune	in	a	182.168.1.7
	ether	a	0:aa:0:69:7c:5b
	in	hinfo	"IBM-PC" "MSDOS"
uranus	in	a	182.168.1.8
	ether	a	0:0:e8:a4:0:25
	in	hinfo	"IBM-PC" "MSDOS"
pluto	in	a	182.168.1.9
	ether	a	8:0:9:d:2a:87
	in	hinfo	"HP-Laser-Jet 4" "None"
lp	in	cname	pluto
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
mercury (mercury,-,) (mercury.example.com,-,)
venus (venus,-,) (venus.example.com,-,)
earth (earth,-,) (earth.example.com,-,)
mars (mars,-,) (mars.example.com,-,)
jupiter (jupiter,-,) (jupiter.example.com,-,)
saturn (saturn,-,) (saturn.example.com,-,)
neptune (neptune,-,) (neptune.example.com,-,)
uranus (uranus,-,) (uranus.example.com,-,)
pluto (pluto,-,) (pluto.example.com,-,) (lp,-,) (lp.example.com,-,)
unix venus earth mars
mac saturn
pc mercury neptune uranus
other jupiter pluto
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-ng test.in test.out \
	-g unix UNIX -g mac MacOS -g pc IBM-PC -g other '.*'
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
