#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the broken origin functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the broken origin functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the broken origin functionality
#
cat > test.in << 'fubar'
@ IN SOA leary.deepwell.com. root.deepwell.com. (
                 990616  ; serial number
                 43200   ; refresh every
                 7200    ; retry after
                 604800  ; expire after
                 3600)   ; default ttl
                         IN      NS      leary.deepwell.com.
                         IN      NS      ns.dcomm.net.
;
; Mail Exchange Records
;
                         IN      MX      10      deepwell.com.
                         IN      MX      20      dante.deepwell.com.
;
; Host Records
;
                         IN      A        209.63.177.68

www                     IN      CNAME   constructionclaim.com.
ftp                     IN      CNAME   constructionclaim.com.
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter test.in test.out 2> test.err
if test $? -ne 1 ; then cat test.err; fail; fi

cat > test.ok << 'fubar'
$origin b.o.g.u.s.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 1 "test.in"
@		in	soa	leary.deepwell.com. root.deepwell.com. (
				990616	; serial
				43200	; refresh: 12 hours
				7200	; retry: 2 hours
				604800	; expire: 1 week
				3600 )	; minimum: 1 hour
		in	ns	leary.deepwell.com.
		in	ns	ns.dcomm.net.



		in	mx	10 deepwell.com.
		in	mx	20 dante.deepwell.com.



		in	a	209.63.177.68

www		in	cname	constructionclaim.com.
ftp		in	cname	constructionclaim.com.
fubar
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
dns-filter: test.in: 1: no origin specified
dns-filter: test.in: found 1 fatal error
fubar
if test $? -ne 0 ; then fail; fi

diff test.ok test.err
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
