#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the bootp functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the bootp functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the bootp functionality
#
cat > test.in << 'fubar'
$origin test.
@ in soa test. hostmaster.test. ( 1 2 3 4 5 )
eric bootp tc this.is.wrong
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
dns-bootp: test.in: 3: the ``tc'' name must be alphanumeric
dns-bootp: test.in: found 1 fatal error
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-bootp test.in > test.out 2>&1
if test $? -ne 1 ; then cat test.out; fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
