#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-bootp functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the dns-bootp functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-bootp functionality
#
cat > test.in << 'fubar'
$origin test.
@	in	soa	1 2 3 4 5 6 7
	in	ns	two
*	bootp	hn	yes
one	in	a	192.192.192.1
	ether	a	1:2:3:4:5:6
	bootp	tc	some-other-place
	bootp	ts	timehost
	bootp	to	auto
two	in	a	192.192.192.2
timehost in	cname	one
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
# Do not edit this file.  It is generated
# using a 'dns-bootp test.in test.out' command.
one.test:\
	:tc=some-other-place:\
	:ds=192.192.192.2:\
	:ha=010203040506:\
	:hn:\
	:ip=192.192.192.1:\
	:to=auto:\
	:ts=192.192.192.1:
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-bootp test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
