#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the bootparams functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the bootparams functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the bootparams functionality
#
cat > test.in << 'fubar'
$origin bogus.
@ in soa 1 2 3 4 5 6 7
*	bootparam root	server1 /path1/$karch/junk
 	bootparam install server2 /path2
 	bootparam boottype in
 	bootparam install_config server3 /path3
one	in	a	192.192.192.1
	ether	a	1:2:3:4:5:6
	bootparam karch	xyz
two	in	a	192.192.192.2
	ether	a	2:3:4:5:6:7
	in	hinfo	"Sun-4/20" "UNIX"
	bootparam karch	sun4m
three	in	a	192.192.192.3
	ether	a	3:4:5:6:7:8
	in	hinfo	"IBM-PC" "UNIX"
	bootparam karch	i86pc
server1 in a 192.192.192.101
server2 in a 192.192.192.102
server3 in a 192.192.192.103
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
# Do not edit this file.  It is generated
# using a 'dns-bootparams test.in test.out' command.
one \
	boottype=:in \
	install=server2:/path2 \
	install_config=server3:/path3 \
	karch=:xyz \
	root=server1:/path1/xyz/junk
two \
	aarch=:sparc \
	boottype=:in \
	install=server2:/path2 \
	install_config=server3:/path3 \
	karch=:sun4m \
	root=server1:/path1/sun4m/junk
three \
	aarch=:i386 \
	boottype=:in \
	install=server2:/path2 \
	install_config=server3:/path3 \
	karch=:i86pc \
	root=server1:/path1/i86pc/junk
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-bootparams test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
