#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the long line printing functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the long line printing functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the long line printing functionality
#
cat > test.in << 'fubar'
$origin nothing.
@ in soa 1 2 3 4 5 6 7
x in hinfo "IBM-PC a b c d e f g h i j k l m n o p q" "MSDOS i j k l m n o p q r s t u v w x y z"
y in hinfo "IBM-PC ;try (printing) this!" "MSDOS \"or\" this \\and\\ this \7"
fubar
if test $? -ne 0 ; then fail; fi

cat > ok << 'fubar'
$origin nothing.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 2 "test.in"
@		in	soa	1 2 (
				3	; serial
				4	; refresh: 4 seconds
				5	; retry: 5 seconds
				6	; expire: 6 seconds
				7 )	; minimum: 7 seconds
$line 3 "test.in"
x		in	hinfo	( "IBM-PC a b c d e f g h i j k l m n o p q"
				"MSDOS i j k l m n o p q r s t u v w x y z" )
$line 4 "test.in"
y		in	hinfo	( "IBM-PC ;try (printing) this!"
				"MSDOS \"or\" this \\and\\ this \007" )
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter test.in test.out
if test $? -ne 0 ; then fail; fi

diff ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
