#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the include and errors functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the include and errors functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the include and errors functionality
#
cat > test.in << 'fubar'
$origin bogus.
@ in soa bogus. fed.bogus. ( 1 1 1 1 1 )
x in a 1 2 3 
$include "test.inc"
fubar
if test $? -ne 0 ; then fail; fi

cat > test.inc << 'fubar'
y in a 1.1.1.1
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter test.in test.out 2> test.err
if test $? -ne 1 ; then fail; fi

cat > ok << 'fubar'
$origin bogus.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 2 "test.in"
@		in	soa	bogus. fed.bogus. (
				1	; serial
				1	; refresh: 1 second
				1	; retry: 1 second
				1	; expire: 1 second
				1 )	; minimum: 1 second
$line 3 "test.in"
x		in	a	1.0.0.0 2 3
$line 1 "test.inc"
y		in	a	1.1.1.1
fubar
if test $? -ne 0 ; then fail; fi
diff ok test.out
if test $? -ne 0 ; then fail; fi

cat > ok << 'fubar'
dns-filter: test.in: 3: 'a' requires 1 arguments, but 3 were given
dns-filter: test.in: found 1 fatal error
fubar
if test $? -ne 0 ; then fail; fi
diff ok test.err
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
