#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the name checking functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the name checking functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the name checking functionality
#
cat > Howto.cook << 'fubar'
test:
{
	fail;
}
fubar
if test $? -ne 0 ; then fail; fi

cat > infile << 'fubar'
$config warning_name_length	8
$origin gertrude.com.
first..error in a 192.1.1.1
Second.warning in a 192.2.2.2
this-name-is-far-too-long in a 192.3.3.3
&bad%name^ in a 192.4.4.4
long-name in a 192.5.5.5
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter infile outfile 2> errors
if test $? -ne 1 ; then cat errors; fail; fi

cat > ok << 'fubar'
dns-filter: infile: 3: name "first..error.gertrude.com." has an empty component
dns-filter: infile: 4: warning: name "Second.warning.gertrude.com." contains 1
	upper case character; please use lower-case names
dns-filter: infile: 5: name "this-name-is-far-too-long.gertrude.com.",
	component "this-name-is-far-too-long" is far too long (by 17)
dns-filter: infile: 6: warning: name "&bad%name^.gertrude.com.", component
	"&bad%name^" is too long (by 2)
dns-filter: infile: 6: name "&bad%name^.gertrude.com." contains 3 illegal
	characters; only letters, digits, hyphen and dot are legal
dns-filter: infile: 7: warning: name "long-name.gertrude.com.", component
	"long-name" is too long (by 1)
dns-filter: infile: found 3 fatal errors
fubar
if test $? -ne 0 ; then fail; fi
diff ok errors
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
