#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-filter functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the dns-filter functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-filter functionality
#
cat > test.in << 'fubar'
$origin just.a.test.
@		in	soa just.a.test. hostmaster.just.a.test. (
				0	;serial
				10800   ; refresh       3 hours
				1800    ; retry         30 minutes
				3600000 ; expire        1000 hours
				86400 ) ; minimum       24 hours
$line 75 "barf"
;
; isn't this fun?
;
one		in	a	192.192.192.1
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
$origin just.a.test.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 2 "test.in"
@		in	soa	just.a.test. hostmaster.just.a.test. (
				0	; serial
				10800	; refresh: 3 hours
				1800	; retry: 30 minutes
				3600000	; expire: 5 weeks, 6 days, 16 hours
				86400 )	; minimum: 1 day
$line 78 "barf"
one		in	a	192.192.192.1
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test the dns-filter functionality
#
cat > test.in << 'fubar'
$origin just.a.test.
@		in	soa just.a.test. hostmaster.just.a.test. (
				0 10800   1800 3600000 86400 )
one		in	a	192.192.192.1
		ether	a	1:2:3:4:5:6
jatz.aarnet.edu.au. in	a	139.130.204.4
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
$origin just.a.test.
$config	maximum_name_length	15
$config	warning_name_length	0
$config	allow_upper_case	0
$line 2 "test.in"
@		in	soa	just.a.test. hostmaster.just.a.test. (
				0	; serial
				10800	; refresh: 3 hours
				1800	; retry: 30 minutes
				3600000	; expire: 5 weeks, 6 days, 16 hours
				86400 )	; minimum: 1 day
$line 4 "test.in"
one		in	a	192.192.192.1
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-filter -dc ether -dfn test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
