#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1995, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-ethers functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the dns-ethers functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the dns-ethers functionality
#
cat > test.in << 'fubar'
$origin just.a.test.
@		in	soa	just.a.test.	hostmaster.just.a.test. (
					1.1	; serial
					21600	; refresh	6 hours
					900	; retry		15 minutes
					3600000	; expire	1000 hours
					21600 )	; minimum	6 hours
one		in	a	192.192.192.1
		ether	a	1:2:3:4:5:6
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
# Do not edit this file.  It is generated
# using a 'dns-ethers test.in test.out' command.
1:2:3:4:5:6	one
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-ethers test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test that dns-ethers detects illegal Ethernet addresses
#
cat > test.in << 'fubar'
$origin just.a.test.
@		in	soa	just.a.test.	hostmaster.just.a.test. (
					1.1	; serial
					21600	; refresh	6 hours
					900	; retry		15 minutes
					3600000	; expire	1000 hours
					21600 )	; minimum	6 hours
one		in	a	192.192.192.1
		ether	a	1:2:3:4:5:6
two		in	a	192.192.192.2
		ether	a	6:7:8:09:a:b
three		in	a	192.192.192.3
		ether	a	010203040506
four		in	a	192.192.192.4
		ether	a	cc:dd:ee:ff:gg:hh
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
dns-ethers: test.in: 13: the string "010203040506" is not a legal Ethernet
	address
dns-ethers: test.in: 15: the string "cc:dd:ee:ff:gg:hh" is not a legal Ethernet
	address
dns-ethers: test.in: found 2 fatal errors
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-ethers test.in > test.out 2>&1
if test $? -ne 1 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test that dns-ethers detects duplicate Ethernet addresses
#
cat > test.in << 'fubar'
$origin just.a.test.
@		in	soa	just.a.test.	hostmaster.just.a.test. (
					1.1	; serial
					21600	; refresh	6 hours
					900	; retry		15 minutes
					3600000	; expire	1000 hours
					21600 )	; minimum	6 hours
one		in	a	192.192.192.1
		ether	a	1:2:3:4:5:6
two		in	a	192.192.192.2
		ether	a	1:2:3:04:5:6
three		in	a	192.192.192.3
		ether	a	2:3:4:5:6:7
four		in	a	192.192.192.4
		ether	a	f:e:d:c:b:a
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
dns-ethers: test.in: 11: duplicate 1:2:3:4:5:6 host Ethernet address
dns-ethers: test.in: 9: ...here is the first definition
dns-ethers: test.in: found 1 fatal error
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-ethers test.in > test.out 2>&1
if test $? -ne 1 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
