#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the duplicate scanning functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the duplicate scanning functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the duplicate scanning functionality
#
cat > test.in << 'fubar'
$origin example.
@		in	soa	example. hostmaster.example. (
			;	YYYYMMDDnn
				1992100601 ; serial
				10800	; refresh	3 hours
				1800	; retry		30 minutes
				3600000	; expire	1000 hours
				86400 )	; minimum	24 hours
test1	in	a	192.9.200.1
	in	hinfo	unknown none
test2	in	a	192.9.200.2
	in	hinfo	unknown none
test3	in	a	192.9.200.3
	in	hinfo	unknown none
test4	in	a	192.9.200.4
	in	hinfo	unknown none
test5	in	a	192.9.200.5
	in	hinfo	unknown none
test6	in	a	192.9.200.6
	in	hinfo	unknown none
test7	in	a	192.9.200.7
	in	hinfo	unknown none
test8	in	a	192.9.200.8
	in	hinfo	unknown none
test9	in	a	192.9.200.9
	in	hinfo	unknown none
test1	in	a	192.9.200.10
	in	hinfo	unknown none
test11	in	a	192.9.200.11
	in	hinfo	unknown none
test12	in	a	192.9.200.12
	in	hinfo	unknown none
test13	in	a	192.9.200.13
	in	hinfo	unknown none
test14	in	a	192.9.200.14
	in	hinfo	unknown none
test15	in	a	192.9.200.15
	in	hinfo	unknown none
test16	in	a	192.9.200.16
	in	hinfo	unknown none
test17	in	a	192.9.200.7
	in	hinfo	unknown none
test18	in	a	192.9.200.18
	in	hinfo	unknown none
test19	in	a	192.9.200.19
	in	hinfo	unknown none
test20	in	a	192.9.200.20
	in	hinfo	unknown none
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
dns-hosts: test.in: 27: duplicate "test1.example." host name
dns-hosts: test.in: 9: ...here is the first definition
dns-hosts: test.in: 41: warning: address 192.9.200.7 out of order
dns-hosts: test.in: 41: duplicate 192.9.200.7 host IP address
dns-hosts: test.in: 21: ...here is the first definition
dns-hosts: test.in: found 2 fatal errors
fubar
if test $? -ne 0 ; then fail; fi

$bin/dns-hosts test.in test.out 2> test.err
if test $? -ne 1 ; then fail; fi

diff test.ok test.err
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
