#!/bin/sh
#
#	dnsuts - utilities to make DNS easier to configure
#	Copyright (C) 1993, 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-ng command
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo FAILED test of dns-ng command 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# with input like this
#
cat > test.in << 'fubar'
$origin example.
@		in	soa	example. hostmaster.example. (
			;	YYYYMMDDnn
				1992100601 ; serial
				10800	; refresh	3 hours
				1800	; retry		30 minutes
				3600000	; expire	1000 hours
				86400 )	; minimum	24 hours
test1	in	a	192.9.200.1
	in	hinfo	unknown none
test2	in	a	192.9.200.2
	in	hinfo	unknown none
test3	in	a	192.9.200.3
	in	hinfo	unknown none
test4	in	a	192.9.200.4
	in	hinfo	unknown none
test5	in	a	192.9.200.5
	in	hinfo	unknown none
test6	in	a	192.9.200.6
	in	hinfo	unknown none
test7	in	a	192.9.200.7
	in	hinfo	unknown none
test8	in	a	192.9.200.8
	in	hinfo	unknown none
test9	in	a	192.9.200.9
	in	hinfo	unknown none
test10	in	a	192.9.200.10
	in	hinfo	unknown none
test11	in	a	192.9.200.11
	in	hinfo	unknown none
test12	in	a	192.9.200.12
	in	hinfo	unknown none
test13	in	a	192.9.200.13
	in	hinfo	unknown none
test14	in	a	192.9.200.14
	in	hinfo	unknown none
test15	in	a	192.9.200.15
	in	hinfo	unknown none
test16	in	a	192.9.200.16
	in	hinfo	unknown none
test17	in	a	192.9.200.17
	in	hinfo	unknown none
test18	in	a	192.9.200.18
	in	hinfo	unknown none
test19	in	a	192.9.200.19
	in	hinfo	unknown none
test20	in	a	192.9.200.20
	in	hinfo	unknown none
test21	in	a	192.9.200.21
	in	hinfo	unknown none
test22	in	a	192.9.200.22
	in	hinfo	unknown none
test23	in	a	192.9.200.23
	in	hinfo	unknown none
test24	in	a	192.9.200.24
	in	hinfo	unknown none
test25	in	a	192.9.200.25
	in	hinfo	unknown none
test26	in	a	192.9.200.26
	in	hinfo	unknown none
test27	in	a	192.9.200.27
	in	hinfo	unknown none
test28	in	a	192.9.200.28
	in	hinfo	unknown none
test29	in	a	192.9.200.29
	in	hinfo	unknown none
test30	in	a	192.9.200.30
	in	hinfo	unknown none
test31	in	a	192.9.200.31
	in	hinfo	unknown none
test32	in	a	192.9.200.32
	in	hinfo	unknown none
test33	in	a	192.9.200.33
	in	hinfo	unknown none
test34	in	a	192.9.200.34
	in	hinfo	unknown none
test35	in	a	192.9.200.35
	in	hinfo	unknown none
test36	in	a	192.9.200.36
	in	hinfo	unknown none
test37	in	a	192.9.200.37
	in	hinfo	unknown none
test38	in	a	192.9.200.38
	in	hinfo	unknown none
test39	in	a	192.9.200.39
	in	hinfo	unknown none
test40	in	a	192.9.200.40
	in	hinfo	unknown none
test41	in	a	192.9.200.41
	in	hinfo	unknown none
test42	in	a	192.9.200.42
	in	hinfo	unknown none
test43	in	a	192.9.200.43
	in	hinfo	unknown none
test44	in	a	192.9.200.44
	in	hinfo	unknown none
test45	in	a	192.9.200.45
	in	hinfo	unknown none
test46	in	a	192.9.200.46
	in	hinfo	unknown none
test47	in	a	192.9.200.47
	in	hinfo	unknown none
test48	in	a	192.9.200.48
	in	hinfo	unknown none
test49	in	a	192.9.200.49
	in	hinfo	unknown none
test50	in	a	192.9.200.50
	in	hinfo	unknown none
test51	in	a	192.9.200.51
	in	hinfo	unknown none
test52	in	a	192.9.200.52
	in	hinfo	unknown none
test53	in	a	192.9.200.53
	in	hinfo	unknown none
test54	in	a	192.9.200.54
	in	hinfo	unknown none
test55	in	a	192.9.200.55
	in	hinfo	unknown none
test56	in	a	192.9.200.56
	in	hinfo	unknown none
test57	in	a	192.9.200.57
	in	hinfo	unknown none
test58	in	a	192.9.200.58
	in	hinfo	unknown none
test59	in	a	192.9.200.59
	in	hinfo	unknown none
test60	in	a	192.9.200.60
	in	hinfo	unknown none
test61	in	a	192.9.200.61
	in	hinfo	unknown none
test62	in	a	192.9.200.62
	in	hinfo	unknown none
test63	in	a	192.9.200.63
	in	hinfo	unknown none
test64	in	a	192.9.200.64
	in	hinfo	unknown none
test65	in	a	192.9.200.65
	in	hinfo	unknown none
test66	in	a	192.9.200.66
	in	hinfo	unknown none
test67	in	a	192.9.200.67
	in	hinfo	unknown none
test68	in	a	192.9.200.68
	in	hinfo	unknown none
test69	in	a	192.9.200.69
	in	hinfo	unknown none
test70	in	a	192.9.200.70
	in	hinfo	unknown none
test71	in	a	192.9.200.71
	in	hinfo	unknown none
test72	in	a	192.9.200.72
	in	hinfo	unknown none
test73	in	a	192.9.200.73
	in	hinfo	unknown none
test74	in	a	192.9.200.74
	in	hinfo	unknown none
test75	in	a	192.9.200.75
	in	hinfo	unknown none
test76	in	a	192.9.200.76
	in	hinfo	unknown none
test77	in	a	192.9.200.77
	in	hinfo	unknown none
test78	in	a	192.9.200.78
	in	hinfo	unknown none
test79	in	a	192.9.200.79
	in	hinfo	unknown none
test80	in	a	192.9.200.80
	in	hinfo	unknown none
test81	in	a	192.9.200.81
	in	hinfo	unknown none
test82	in	a	192.9.200.82
	in	hinfo	unknown none
test83	in	a	192.9.200.83
	in	hinfo	unknown none
test84	in	a	192.9.200.84
	in	hinfo	unknown none
test85	in	a	192.9.200.85
	in	hinfo	unknown none
test86	in	a	192.9.200.86
	in	hinfo	unknown none
test87	in	a	192.9.200.87
	in	hinfo	unknown none
test88	in	a	192.9.200.88
	in	hinfo	unknown none
test89	in	a	192.9.200.89
	in	hinfo	unknown none
test90	in	a	192.9.200.90
	in	hinfo	unknown none
test91	in	a	192.9.200.91
	in	hinfo	unknown none
test92	in	a	192.9.200.92
	in	hinfo	unknown none
test93	in	a	192.9.200.93
	in	hinfo	unknown none
test94	in	a	192.9.200.94
	in	hinfo	unknown none
test95	in	a	192.9.200.95
	in	hinfo	unknown none
test96	in	a	192.9.200.96
	in	hinfo	unknown none
test97	in	a	192.9.200.97
	in	hinfo	unknown none
test98	in	a	192.9.200.98
	in	hinfo	unknown none
test99	in	a	192.9.200.99
	in	hinfo	unknown none
test100	in	a	192.9.200.100
	in	hinfo	unknown none
test101	in	a	192.9.200.101
	in	hinfo	unknown none
fubar
if test $? -ne 0 ; then fail; fi

#
# must be output like this
#
cat > test.ok << 'fubar'
test1 (test1,-,) (test1.example,-,)
test2 (test2,-,) (test2.example,-,)
test3 (test3,-,) (test3.example,-,)
test4 (test4,-,) (test4.example,-,)
test5 (test5,-,) (test5.example,-,)
test6 (test6,-,) (test6.example,-,)
test7 (test7,-,) (test7.example,-,)
test8 (test8,-,) (test8.example,-,)
test9 (test9,-,) (test9.example,-,)
test10 (test10,-,) (test10.example,-,)
test11 (test11,-,) (test11.example,-,)
test12 (test12,-,) (test12.example,-,)
test13 (test13,-,) (test13.example,-,)
test14 (test14,-,) (test14.example,-,)
test15 (test15,-,) (test15.example,-,)
test16 (test16,-,) (test16.example,-,)
test17 (test17,-,) (test17.example,-,)
test18 (test18,-,) (test18.example,-,)
test19 (test19,-,) (test19.example,-,)
test20 (test20,-,) (test20.example,-,)
test21 (test21,-,) (test21.example,-,)
test22 (test22,-,) (test22.example,-,)
test23 (test23,-,) (test23.example,-,)
test24 (test24,-,) (test24.example,-,)
test25 (test25,-,) (test25.example,-,)
test26 (test26,-,) (test26.example,-,)
test27 (test27,-,) (test27.example,-,)
test28 (test28,-,) (test28.example,-,)
test29 (test29,-,) (test29.example,-,)
test30 (test30,-,) (test30.example,-,)
test31 (test31,-,) (test31.example,-,)
test32 (test32,-,) (test32.example,-,)
test33 (test33,-,) (test33.example,-,)
test34 (test34,-,) (test34.example,-,)
test35 (test35,-,) (test35.example,-,)
test36 (test36,-,) (test36.example,-,)
test37 (test37,-,) (test37.example,-,)
test38 (test38,-,) (test38.example,-,)
test39 (test39,-,) (test39.example,-,)
test40 (test40,-,) (test40.example,-,)
test41 (test41,-,) (test41.example,-,)
test42 (test42,-,) (test42.example,-,)
test43 (test43,-,) (test43.example,-,)
test44 (test44,-,) (test44.example,-,)
test45 (test45,-,) (test45.example,-,)
test46 (test46,-,) (test46.example,-,)
test47 (test47,-,) (test47.example,-,)
test48 (test48,-,) (test48.example,-,)
test49 (test49,-,) (test49.example,-,)
test50 (test50,-,) (test50.example,-,)
test51 (test51,-,) (test51.example,-,)
test52 (test52,-,) (test52.example,-,)
test53 (test53,-,) (test53.example,-,)
test54 (test54,-,) (test54.example,-,)
test55 (test55,-,) (test55.example,-,)
test56 (test56,-,) (test56.example,-,)
test57 (test57,-,) (test57.example,-,)
test58 (test58,-,) (test58.example,-,)
test59 (test59,-,) (test59.example,-,)
test60 (test60,-,) (test60.example,-,)
test61 (test61,-,) (test61.example,-,)
test62 (test62,-,) (test62.example,-,)
test63 (test63,-,) (test63.example,-,)
test64 (test64,-,) (test64.example,-,)
test65 (test65,-,) (test65.example,-,)
test66 (test66,-,) (test66.example,-,)
test67 (test67,-,) (test67.example,-,)
test68 (test68,-,) (test68.example,-,)
test69 (test69,-,) (test69.example,-,)
test70 (test70,-,) (test70.example,-,)
test71 (test71,-,) (test71.example,-,)
test72 (test72,-,) (test72.example,-,)
test73 (test73,-,) (test73.example,-,)
test74 (test74,-,) (test74.example,-,)
test75 (test75,-,) (test75.example,-,)
test76 (test76,-,) (test76.example,-,)
test77 (test77,-,) (test77.example,-,)
test78 (test78,-,) (test78.example,-,)
test79 (test79,-,) (test79.example,-,)
test80 (test80,-,) (test80.example,-,)
test81 (test81,-,) (test81.example,-,)
test82 (test82,-,) (test82.example,-,)
test83 (test83,-,) (test83.example,-,)
test84 (test84,-,) (test84.example,-,)
test85 (test85,-,) (test85.example,-,)
test86 (test86,-,) (test86.example,-,)
test87 (test87,-,) (test87.example,-,)
test88 (test88,-,) (test88.example,-,)
test89 (test89,-,) (test89.example,-,)
test90 (test90,-,) (test90.example,-,)
test91 (test91,-,) (test91.example,-,)
test92 (test92,-,) (test92.example,-,)
test93 (test93,-,) (test93.example,-,)
test94 (test94,-,) (test94.example,-,)
test95 (test95,-,) (test95.example,-,)
test96 (test96,-,) (test96.example,-,)
test97 (test97,-,) (test97.example,-,)
test98 (test98,-,) (test98.example,-,)
test99 (test99,-,) (test99.example,-,)
test100 (test100,-,) (test100.example,-,)
test101 (test101,-,) (test101.example,-,)
all-00 test1 test2 test3 test4 test5 test6
all-01 test7 test8 test9 test10 test11
all-0 all-00 all-01
all-10 test12 test13 test14 test15 test16 test17
all-11 test18 test19 test20 test21 test22
all-1 all-10 all-11
all-20 test23 test24 test25 test26 test27 test28
all-21 test29 test30 test31 test32 test33
all-2 all-20 all-21
all-30 test34 test35 test36 test37 test38 test39
all-31 test40 test41 test42 test43 test44
all-3 all-30 all-31
all-40 test45 test46 test47 test48 test49 test50
all-41 test51 test52 test53 test54 test55
all-4 all-40 all-41
all-50 test56 test57 test58 test59 test60 test61
all-51 test62 test63 test64 test65 test66
all-5 all-50 all-51
all-60 test67 test68 test69 test70 test71 test72
all-61 test73 test74 test75 test76 test77
all-6 all-60 all-61
all-70 test78 test79 test80 test81 test82 test83
all-71 test84 test85 test86 test87 test88
all-7 all-70 all-71
all-80 test89 test90 test91 test92 test93 test94
all-81 test95 test96 test97 test98 test99
all-8 all-80 all-81
all-9 test100 test101
all all-0 all-1 all-2 all-3 all-4 all-5 all-6 all-7 all-8 all-9
fubar
if test $? -ne 0 ; then fail; fi

#
# do it an see
#
$bin/dns-ng test.in test.out -g all '.*'
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
