#!/bin/sh
#
#	dns-utils - utilities to make DNS easier to configure
#	Copyright (C) 1992, 1993, 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-ng command
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo FAILED test of the dns-ng command 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

cat > test.in << 'foobar'
$origin example.
@		in	soa	example. hostmaster.example. (
			;	YYYYMMDDnn
				1992100601 ; serial
				10800	; refresh	3 hours
				1800	; retry		30 minutes
				3600000	; expire	1000 hours
				86400 )	; minimum	24 hours
example.	in	mx	10 one.example.
localhost	in	a	127.0.0.1
loghost		in	cname	localhost
loopback	in	cname	localhost
one		in	a	192.9.200.1
		in	hinfo	"Sun-4/40" "UNIX SunOS 4.1"
ipcone		in	cname	one
mailhost	in	cname	one
two		in	a	192.9.200.2
		in	hinfo	"unknown" "unknown"
ipctwo		in	cname	two
three		in	a	192.9.200.3
		in	hinfo	"Sun-4/40" "UNIX SunOS 4.1"
foobar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'foobar'
localhost (localhost,-,) (localhost.example,-,) (loghost,-,) (loghost.example,-,) (loopback,-,) (loopback.example,-,)
one (one,-,) (one.example,-,) (ipcone,-,) (ipcone.example,-,) (mailhost,-,) (mailhost.example,-,)
two (two,-,) (two.example,-,) (ipctwo,-,) (ipctwo.example,-,)
three (three,-,) (three.example,-,)
unix one three
junk two
foobar
if test $? -ne 0 ; then fail; fi

$bin/dns-ng -g unix 'UNIX.*' -g junk '.*' test.in test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then cat test.out ; fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
