#!/bin/sh
#
#	dns-utils - utilities to make DNS easier to configure
#	Copyright (C) 1992, 1993, 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-rev command.
#
tmp=/tmp/$$
PAGER=cat
export PAGER
umask 022
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	echo FAILED test of dns-rev command 1>&2
	cd $here
	rm -rf $tmp
	exit 1
}
pass()
{
	cd $here
	rm -rf $tmp
	exit 0
}
trap "fail" 1 2 3 15

mkdir $tmp
cd $tmp

cat > test.in << 'foobar'
;
; some comments
;
$origin bmr.gov.au.
@		in	soa	bmr.gov.au.	hostmaster.bmr.gov.au. (
				1.1	; serial
				21600   ; refresh: 6 hours
				900     ; retry: 15 minutes
				3600000 ; expire: 5 weeks, 6 days, 16 hours
				21600 ) ; minimum: 6 hours
		in	ns	one
		in	ns	two
bmr.gov.au.	in	mx	10 one.bmr.gov.au.
*.bmr.gov.au.	in	mx	10 one.bmr.gov.au.
one		in	a	192.104.43.1
		in	hinfo	"Sun-4/280" "UNIX SunOS 4.1"
garnet		in	cname	one
two		in	a	192.104.43.2
		in	hinfo	"Sun-4/280" "UNIX SunOS 4.1"
topaz		in	cname	two
foobar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'foobar'
; Do not edit this file.  It is generated
; by a 'dns-rev test.in test.out' command.
$origin 43.104.192.in-addr.arpa.
@		in	soa	bmr.gov.au. hostmaster.bmr.gov.au. (
				1.1	; serial
				21600	; refresh: 6 hours
				900	; retry: 15 minutes
				3600000	; expire: 5 weeks, 6 days, 16 hours
				21600 )	; minimum: 6 hours
		in	ns	one.bmr.gov.au.
		in	ns	two.bmr.gov.au.
1		in	ptr	one.bmr.gov.au.
2		in	ptr	two.bmr.gov.au.
foobar
if test $? -ne 0 ; then fail; fi

$bin/dns-rev test.in  test.out
if test $? -ne 0 ; then fail; fi

diff test.out test.ok
if test $? -ne 0 ; then fail; fi

# probably OK
pass
