#!/bin/sh
#
#	dns-utils - utilities to make DNS easier to configure
#	Copyright (C) 1992, 1993, 1995, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
# 
# MANIFEST: test the dns-hosts command, help and version
#
tmp=/tmp/$$
PAGER=cat
export PAGER
umask 022
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	echo FAILED test of dns-hosts command, help or version option 1>&2
	exit 1
}
pass()
{
	exit 0
}
trap "fail" 1 2 3 15

mkdir $tmp
cd $tmp

$bin/dns-hosts -help > /dev/null 2>&1
if [ $? -ne 0 -a $? -ne 1 ]; then fail; fi

$bin/dns-hosts -version > /dev/null 2>&1
if [ $? -ne 0 ]; then fail; fi

# probably OK
pass
