#!/bin/sh
#
#	dns-utils - utilities to make DNS easier to configure
#	Copyright (C) 1992, 1993, 1995, 1996, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the dns-hosts command.
#
tmp=/tmp/$$
PAGER=cat
export PAGER
umask 022
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	echo FAILED test of dns-hosts command 1>&2
	cd $here
	rm -rf $tmp
	exit 1
}
pass()
{
	cd $here
	rm -rf $tmp
	exit 0
}
trap "fail" 1 2 3 15

mkdir $tmp
cd $tmp

cat > test.in << 'foobar'
;
; some comments
;
$origin q.
@		in	soa	q.	hostmaster.q. (
					1.1	; serial
					21600	; refresh	6 hours
					900	; retry		15 minutes
					3600000	; expire	1000 hours
					21600 )	; minimum	6 hours
q.	in	mx	10 ipcone.q.
*.q.	in	mx	10 ipcone.q.
;
; Image Processing Centre, ISB
ipcone		in	a	192.104.43.1
		in	hinfo	"Sun-4/280" "UNIX SunOS 4.1"
garnet		in	cname	ipcone
;
; Image Processing Centre, ISB
ipctwo		in	a	192.104.43.2
		in	hinfo	"Sun-4/280" "UNIX SunOS 4.1"
topaz		in	cname	ipctwo
;
; hermaphrodite
bozo		in	a	192.104.43.253
bozette		in	cname	bozo
foo		in	a	192.104.43.252
foobar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'foobar'
# Do not edit this file.  It is generated
# using a 'dns-hosts test.in test.out' command.
192.104.43.1	ipcone	ipcone.q garnet garnet.q	# Sun-4/280, UNIX SunOS 4.1
192.104.43.2	ipctwo	ipctwo.q topaz topaz.q	# Sun-4/280, UNIX SunOS 4.1
192.104.43.253	bozo	bozo.q bozette bozette.q
192.104.43.252	foo	foo.q
foobar
if test $? -ne 0 ; then fail; fi

$bin/dns-hosts test.in test.out 2> test.err
if test $? -ne 0 ; then fail; fi

diff test.out test.ok
if test $? -ne 0 ; then fail; fi

# probably OK
pass
