#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: shell script to generate RedHat spec file
#
version=${version-0.0.0}
echo 'Summary: utilities to make DNS easier to configure'
echo 'Name: dnsutl'
echo "Version: ${version}"
echo 'Release: 1'
echo 'Copyright: GPL'
echo 'Group: Networking/Admin'
echo "Source: http://www.canb.auug.org.au/~millerp/dnsutl/dnsutl-${version}.tar.gz"
echo 'URL: http://www.canb.auug.org.au/~millerp/dnsutl/'
echo 'BuildRoot: /tmp/dnsutl-build-root'
echo 'Icon: dnsutl.gif'

prefix=/usr
#
# RPM only has install-time relocatable packages.  It has no support for
# build-time relocatable packages.  Therefore, we must NOT specify a Spec
# prefix, or the installed locations will not match the built locations.
#
#echo "Prefix: $prefix"

echo ''

cat << 'fubar'
%description
The dnsutl package is a collection of tools to make administering
DNS easier.  The tools include:

dns-rev: Take the forward DNS mapping and generate the reverse mapping.

dns-hosts: Take the forward DNS mapping and generate the /etc/hosts file.

dns-ng: Take the forward DNS mapping and generate the /etc/netgroup file.

dns-ethers: By using a bogus record type, you can keep the MAC address
	with the IP address, and generate the /etc/ethers file.

dns-bootp: Using the MAC and IP information, you can generate the
	/etc/bootptab file.

dns-bootparams: Using the MAC and IP information, you can generate the
	Sun /etc/bootparams file.

All of these programs are both faster than shell scripts, and more
robust when faced with all the peculiar semantics of DNS resource files.
They even understand the \f(CW$include\fP directive.

%prep
fubar

#
# set the prefix here
#
echo '%setup'
echo "./configure --prefix=$prefix"
echo ''
echo '%build'
echo 'make'
echo ''
echo '%install'
echo 'make RPM_BUILD_ROOT=$RPM_BUILD_ROOT install'

#
# remember things for the %files section
#
binfiles=
files=

for file in $*
do
	case $file in

	common/*)
		;;
	etc/*)
		;;

	*/main.c)
		prog=`echo $file | sed 's|/main.c$||'`
		dst="$prefix/bin/$prog"
		binfiles="$binfiles $dst"
		;;

	test/*)
		;;

	man?/*.[1-9])
		stem=`echo $file | sed 's|^lib/||'`
		dst="$prefix/man/$stem"
		files="$files $dst"
		;;

	lib/*)
		rest=`echo $file | sed 's|^lib/||'`
		dst="$prefix/share/dnsutl/$rest"
		files="$files $dst"
		;;

	*)
		;;
	esac
done

echo ''
echo '%files'
for file in $binfiles
do
	echo "%attr(0755,root,root) $file"
done
for file in $files
do
	echo "%attr(0644,root,root) $file"
done
