#!/bin/sh
#
#	dnsutl - utilities to make DNS easier to configure
#	Copyright (C) 1991, 1992, 1993, 1995, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: shell script to generate Makefile
#
common_files=
test_files=
clean_files="core y.tab.c y.tab.h .bin .bindir"
man_files=
dns_hosts_files=
dns_ng_files=
dns_rev_files=
commands=

#
# Emit the rules to build a directory, and all the ones above it.
#
recursive_mkdir()
{
	src_dir="$1"
	dst_dir="$2"
	flavor="${3-datadir}"
	while :
	do
		dirvar=`echo $src_dir | sed 's|[^a-zA-Z]|_|g'`
		dotdot1=`dirname ${src_dir-.}`
		dotdot2=`dirname ${dst_dir-.}`
		if eval "test \${${dirvar}_${flavor}-no} != yes" ; then
			echo ""
			if test "$dotdot1" != "." -a "$dotdot2" != "." ; then
				echo "$src_dir/.${flavor}: $dotdot1/.${flavor}"
			else
				echo "$src_dir/.${flavor}:"
			fi
			echo "	-\$(INSTALL) -m 0755 -d $dst_dir"
			echo "	@-test -d $dst_dir && touch \$@"
			echo "	@sleep 1"
			eval "${dirvar}_${flavor}=yes"
			clean_files="$clean_files $src_dir/.${flavor}"
		fi
		src_dir=$dotdot1
		dst_dir=$dotdot2
		if test "$src_dir" = "." -o "$dst_dir" = "." ; then break; fi
	done
}

for file in $*
do
	case $file in

	*/*.y)
		dir=`echo $file | sed 's|/.*||' | sed 's/-/_/g'`
		stem=`echo $file | sed 's/\.y$//'`
		clean_files="$clean_files ${stem}.gen.c ${stem}.gen.h \
${stem}.gen.\$(OBJEXT)"
		eval "${dir}_files=\"\$${dir}_files ${stem}.gen.\\\$(OBJEXT)\""
		;;

	*/*.c)
		dir=`echo $file | sed 's|/.*||' | sed 's/-/_/g'`
		stem=`echo $file | sed 's/\.c$//'`
		eval "${dir}_files=\"\$${dir}_files ${stem}.\\\$(OBJEXT)\""
		clean_files="$clean_files ${stem}.\$(OBJEXT)"

		case $file in
		dns*/main.c)
			command=`echo $file | sed 's|\(.*\)/main.c|\1|'`
			commands="$commands $command"
			;;
		*)
			;;
		esac
		;;

	test/*/*)
		root=`basename $file .sh`
		test_files="$test_files ${root}"
		;;

	man1/*.1)
		man_files="$man_files \$(mandir)/$file"
		root=`basename $file .1`
		clean_files="$clean_files man1/${root}.h"

		src="$file"
		dst="\$(mandir)/$file"
		recursive_mkdir `dirname $src` `dirname $dst` mandir
		;;

	man1/*.so)
		root=`basename $file .so`
		clean_files="$clean_files man1/${root}.h"
		;;

	*)
		;;
	esac
done

echo ""
echo "CommonObj =" $common_files

echo ""
echo "common/lib.\$(LIBEXT): \$(CommonObj)"
echo "	rm -f common/lib.\$(LIBEXT)"
echo "	\$(AR) qc common/lib.\$(LIBEXT) \$(CommonObj)"
echo "	\$(RANLIB) common/lib.\$(LIBEXT)"

echo ""
echo ".bin:"
echo "	-mkdir bin"
echo "	@test -d bin && touch \$@"
echo "	@sleep 1"

echo ".bindir:"
echo "	-\$(INSTALL) -m 0755 -d \$(bindir)"
echo "	@-test -d \$(bindir) && touch \$@"
echo "	@sleep 1"

ALL=
ALLinst=
for prog in $commands
do
	prog2=`echo $prog | sed 's/-/_/g'`

	echo ""
	eval "echo ${prog2}_files = \$${prog2}_files"


	echo ""
	echo "bin/${prog}\$(EXEEXT): \$(${prog2}_files) common/lib.\$(LIBEXT) .bin"
	echo "	\$(CC) \$(LDFLAGS) -o \$@ \$(${prog2}_files) common/lib.\$(LIBEXT) \$(LIBS)"

	ibin="\$(bindir)/\$(PROGRAM_PREFIX)${prog}\$(PROGRAM_SUFFIX)\$(EXEEXT)"
	echo
	echo "${ibin}: bin/$prog\$(EXEEXT) .bindir"
	echo "	\$(INSTALL_PROGRAM) bin/$prog\$(EXEEXT) \$@"

	ALL="$ALL bin/$prog\$(EXEEXT)"
	ALLinst="$ALLinst ${ibin}"
done

echo ""
echo "all: $ALL"

echo ""
echo "sure:" $test_files
echo "	@echo Passed All Tests"

echo ""
echo "clean-obj:"
echo "	rm -f" $clean_files

echo ""
echo "clean: clean-obj"
echo "	rm -f" $ALL

echo ""
echo "distclean: clean"
echo "	rm -f Makefile common/config.h config.status config.cache config.log"

echo ""
echo "install-bin:" $ALLinst

echo ""
echo "install-man:" $man_files

echo ""
echo "install: install-bin install-man"

exit 0
