'\" t
.\"	dnsutl - utilities to make DNS easier to configure
.\"	Copyright (C) 1995, 1999 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
.\"
.\" MANIFEST: source of the BUILDING file
.\"
.TH building dnsutl
.so version.so
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
dnsutl \- utilities to make DNS easier to configure
.XX "" "The BUILDING File"
.SH SPACE REQUIREMENTS
You will need about 1MB to unpack and build the
.I dnsutl
package.
Your milage may vary.
.br
.ne 1i
.SH SITE CONFIGURATION
The
.B dnsutl
package is configured using the
.I configure
program included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system-dependent variables used during compilation,
and creates the
.I Makefile
and
.I common/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.PP
Normally,
you just
.I cd
to the directory containing 
.IR dnsutl "'s"
source code and type
.RS
.ft CW
.nf
\fB% \fP./configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
\fB% \fPsh configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run \fIconfigure\fP with the \fI--quiet\fP option;
for example,
.RS
.FT CW
.nf
\fB% \fP./configure --quiet
\bB%\fP
.fi
.ft R
.RE
.PP
To compile the
.B dnsutl
package in a different directory from the one
containing the source code,
you must use a version of
.I make
that supports the
.I VPATH variable,
such as
.IR "GNU make" .
.I cd
to the directory where you want the object files and executables to go and run
the
.I configure
script.
.I configure
automatically checks for the source code in the directory that
.I configure
is in and in
.IR \&..
(the parent directory).
If for some reason
.I configure
is not in the source code directory that you are configuring,
then it will report that it can't find the source code.
In that case,
run
.I configure
with the option \f(CW--srcdir=\fP\fIDIR\fP,
where
.I DIR
is the directory that contains the source code.
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B dnsutl
package's files in
.IR /usr/local/bin ,
.IR /usr/local/man ,
etc.
You can specify an installation prefix other than
.I /usr/local
by giving
.I configure
the option \f(CW--prefix=\fP\fIPATH\fP.
.PP
You can specify separate installation prefixes for
architecture-specific files and architecture-independent files.
If you give
.I configure
the option \f(CW--exec-prefix=\fP\fIPATH\fP
the
.B dnsutl
package will use
.I PATH
as the prefix for installing programs and libraries.
Data files and documentation will still use the regular prefix.
Normally,
all files are installed using the same prefix.
.PP
.I configure
ignores any other arguments that you give it.
.br
.ne 2i
.PP
On systems that require unusual options for compilation or linking
that the
.I dnsutl
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne-compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
\fB$ \fPCC='gcc -traditional' LIBS=-lposix ./configure
\fI\&...lots of output...\fP
\fB$\fP
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR cc .
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f(CW-l\fP\fIfoo\fP \f(CW-l\fP\fIbar\fP.
The
.I configure
script will append to this,
rather than replace it.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 1i
.SH BUILDING DNSUTL
All you should need to do is use the
.RS
.ft CW
.nf
\fB% \fPmake
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing several files including:
.IR dns-hosts ,
.IR dns-ng ,
and
.IR dns-rev .
.br
.ne 1.5i
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
\fB% \fPmake clean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I common/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
\fB% \fPmake distclean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
.PP
The file
.I aux/configure.in
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.SS Things That Can Go Wrong
The \fIconfigure\fP script looks for a program called ``soelim'',
which is used to remove include directives from (n)roff input.  It uses
it when constructing the files to install for the \fIman\fP(1) pages.
The rather bold assumption is made that you are using GNU Groff, with
the patch for \fB\-I\fP include search directory command line options.
The patch may be obtained from
http://www.canb.auug.org.au/\%~millerp/\%groff-1.11a.patch
.br
.ne 1i
.SH TESTING DNSUTL
The
.I dnsutl
package comes with a test suite.
To run this test suite, use the command
.RS
.ft CW
.nf
\fB% \fPmake sure
\fI\&...lots of output...\fP
.if n \fBPassed All Tests\fP
.if t \f(CBPassed All Tests\fP
\fB%\fP
.fi
.ft R
.RE
.PP
The tests take a few seconds each,
with a few very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
.ft CW
Passed All Tests
.ft R
.RE
should appear at the end of the make.
.br
.ne 1i
.SH INSTALLING DNSUTL
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I dnsutl
package is installed under the
.I /usr/local
tree by default.
Use the \f(CW--prefix=\fP\fIPATH\fP option to
.I configure
if you want some other path.
.PP
All that is required to install the
.I dnsutl
package is to use the
.RS
.ft CW
.nf
\fB% \fPmake install
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file if you want to bypass the
.I configure
script.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the
.I dnsutl
program,
please do not hesitate to contact the author at
.RS
.ft CW
Peter Miller <millerp@canb.auug.org.au>
.ft R
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
.ft CW
.nf
\fB% \fPdns-hosts -version
.if n \fBdns-hosts version\fP \fI\*(V)\fP
.if t \f(CBdns-hosts version\fP \fI\*(V)\fP
\fI\&...warranty disclaimer...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Please do not send this example;
run the program for the exact version number.
.br
.ne 2i
.SH COPYRIGHT
.I dnsutl
version \*(v)
.br
Copyright
.if n (C)
.if t \(co
\*(Y) Peter Miller;
All rights reserved.
.PP
The
.I dnsutl
package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
It should be in the
.I LICENSE
file included with this distribution.
.so ../man1/author.so
