/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate mains
 */

#include <ac/stdio.h>
#include <ac/stdlib.h>

#include <arglex.h>
#include <error.h>
#include <ethers.h>
#include <help.h>
#include <map_ether.h>
#include <srrf.h>
#include <version.h>


enum
{
	arglex_token_domain,
	arglex_token_include,
	arglex_token_verbose,
};

static arglex_table_ty argtab[] =
{
	{ "-Domain", arglex_token_domain, },
	{ "-\\I*", arglex_token_include, },
	{ "-Include", arglex_token_include, },
	{ "-Verbose", arglex_token_verbose, },
	ARGLEX_TERMINATOR
};


static void usage _((void));

static void
usage()
{
	fprintf(stderr, "usage: %s [ <option>... ][ <infile> [ <outfile> ]]\n", progname);
	fprintf(stderr, "       %s -Help\n", progname);
	exit(1);
}


static void main_help _((void));

static void
main_help()
{
	help((char *)0, usage);
}


int main _((int, char **));

int
main(argc, argv)
	int	argc;
	char	**argv;
{
	char	*infile		= 0;
	char	*outfile	= 0;

	arglex_init(argc, argv, argtab);
	switch (arglex())
	{
	default:
		break;

	case arglex_token_help:
		main_help();
		exit(0);

	case arglex_token_version:
		version();
		exit(0);
	}
	while (arglex_token != arglex_token_eoln)
	{
		switch (arglex_token)
		{
		default:
			error("misplaced \"%s\" option", arglex_value.alv_string);
			usage();

		case arglex_token_string:
			if (!infile)
				infile = arglex_value.alv_string;
			else
			{
				if (outfile)
					too_many_files:
					fatal("too many files named");
				outfile = arglex_value.alv_string;

			}
			break;

		case arglex_token_stdio:
			if (!infile)
				infile = "";
			else
			{
				if (outfile)
					goto too_many_files;
				outfile = "";

			}
			break;

		case arglex_token_domain:
			if (arglex() != arglex_token_string)
				usage();
			ethers_domain(arglex_value.alv_string);
			break;

		case arglex_token_verbose:
			verbose++;
			break;

		case arglex_token_include:
			if (arglex() != arglex_token_string)
				usage();
			srrf_include_path(arglex_value.alv_string);
			break;
		}
		arglex();
	}
	if (infile && !*infile)
		infile = 0;
	if (outfile && !*outfile)
		outfile = 0;

	ethers(infile, outfile);
	exit(0);
	return 0;
}
