/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate etherss
 */

#include <ac/stdio.h>
#include <ac/string.h>
#include <ac/unistd.h>

#include <error.h>
#include <ethers.h>
#include <map_ether.h>
#include <srrf.h>
#include <srrf/origin.h>


	int	verbose;
static	char	*domain;


static string_ty *get_domain_name _((void));

static string_ty *
get_domain_name()
{
	char		buffer[1000];
	char		*tmp;
	char		*ep;

	if (domain && *domain)
		tmp = domain;
	else
	{
#ifdef HAVE_GETDOMAINNAME
		if (getdomainname(buffer, sizeof(buffer)))
			nfatal("getdomainname");
		tmp = buffer;
		if (!*tmp)
#endif
			tmp = "example.com";
	}
	ep = strrchr(tmp, '.');
	if (ep && ep[1] == 0)
		return str_from_c(tmp);
	return str_format("%s.", tmp);
}


void
ethers(infile, outfile)
	char		*infile;
	char		*outfile;
{
	FILE		*fp;
	srrf_t		*rp;
	string_ty	*s;
	string_ty	*s2;
	char		*soa[] = {
				"",	/* server */
				"",	/* hostmaster */
				"3", 	/* seral */
				"10800", /* refresh: 3 hours */
				"1800",	/* retry: 30 minutes */
				"604800", /* expire: 1 week */
				"86400", /* minimum: 1 day */
			};

	/*
	 * open the input file
	 */
	map_ether_open(infile);

	/*
	 * open the output file
	 */
	if (outfile)
	{
		fp = fopen(outfile, "w");
		if (!fp)
			nfatal("creat \"%s\"", outfile);
	}
	else
	{
		outfile = "(stdout)";
		fp = stdout;
	}

	/*
	 * write the origin
	 */
	s = get_domain_name();
	srrf_origin_set(s);
	srrf_origin_print(fp);
	str_free(s);

	/*
	 * write the SOA record
	 */
	rp = srrf_alloc();
	rp->name = str_copy(s);
	rp->class = srrf_class_by_name("in");
	assert(rp->class);
	rp->type = srrf_type_by_name(rp->class, "soa");
	assert(rp->type);
	strlist_append(&rp->arg, srrf_origin_get());
	s2 = str_format("hostmaster.%S", srrf_origin_get());
	strlist_append(&rp->arg, s2);
	str_free(s2);
	while (rp->arg.nstrings < SIZEOF(soa))
	{
		s2 = str_from_c(soa[rp->arg.nstrings]);
		strlist_append(&rp->arg, s2);
		str_free(s2);
	}
	srrf_print(fp, rp);
	srrf_free(rp);

	/*
	 * convert the format
	 */
	for (;;)
	{
		map_ether_t	*mep;

		mep = map_ether_read();
		if (!mep)
			break;
		rp = srrf_alloc();
		rp->name = srrf_relative_to_absolute(mep->name);
		rp->class = srrf_class_by_name("ether");
		rp->type = srrf_type_by_name(rp->class, "a");
		strlist_append(&rp->arg, mep->address);
		srrf_print(fp, rp);
		srrf_free(rp);
		map_ether_delete(mep);
	}

	/*
	 * close the files
	 */
	map_ether_close();
	if (fflush(fp))
		nfatal("write \"%s\"", outfile);
	if (fp != stdout && fclose(fp))
		nfatal("close \"%s\"", outfile);
}


void
ethers_domain(s)
	char	*s;
{
	domain = s;
}
