/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999, 2000 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to parse named.boot files
 */

%{

#include <ac/stdio.h>
#include <ac/stdlib.h>

#include <check.h>
#include <gram.h>
#include <lex.h>
#include <str.h>

%}

%token CACHE
%token DIRECTORY
%token DOMAIN
%token EOLN
%token FORWARDERS
%token PRIMARY
%token SECONDARY
%token STRING

%union {
	string_ty	*lv_string;
}

%type <lv_string> STRING

%{

void
grammar(filename)
	const char	*filename;
{
	extern int yyparse _((void));

	lex_open(filename);
	yyparse();
	lex_close();
}

%}

%%

main
	: /* empty */
	| main directive EOLN
	;

directive
	: /* empty */
	| cache
	| directory
	| domain
	| forwarders
	| primary
	| secondary
	| error
	;

cache
	: CACHE STRING STRING
		{
			check_cache($2, $3);
			str_free($2);
			str_free($3);
		}
	;

directory
	: DIRECTORY STRING
		{
			check_directory($2);
			str_free($2);
		}
	;

domain
	: DOMAIN STRING
		{
			check_domain($2);
			str_free($2);
		}
	;

forwarders
	: FORWARDERS ip_address_list
	;

ip_address_list
	: ip_address
	| ip_address_list ip_address
	;

ip_address
	: STRING
		{
			check_forwarder($1);
			str_free($1);
		}
	;

primary
	: PRIMARY STRING STRING
		{
			check_primary($2, $3);
			str_free($2);
			str_free($3);
		}
	;

secondary
	: SECONDARY STRING STRING
		{
			check_secondary($2, $3);
			str_free($2);
			str_free($3);
		}
	;
