/*
 *	dns-utils - utilities to make DNS easier to configure
 *	Copyright (C) 1991, 1992, 1993, 1995, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#include <ac/stdio.h>
#include <ac/stdlib.h>
#include <ac/string.h>

#include <arglex.h>
#include <error.h>
#include <help.h>
#include <version.h>
#include <version-stmp.h>
#include <mem.h>


static void version_copyright _((void));

static void
version_copyright()
{
	static char *text[] =
	{
		"All rights reserved.",
		"",
		"The %s program comes with ABSOLUTELY NO WARRANTY;",
		"for details use the '%s -VERSion License' command.",
		"The %s program is free software, and you are welcome to",
		"redistribute it under certain conditions;",
		"for details use the '%s -VERSion License' command.",
	};
	char **cpp;

	printf("%s version %s\n", progname, version_stamp());
	printf("Copyright (C) %s Peter Miller;\n", copyright_years());
	for (cpp = text; cpp < ENDOF(text); ++cpp)
	{
		printf(*cpp, progname);
		printf("\n");
	}
}


static void usage _((void));

static void
usage()
{
	fprintf(stderr, "usage: %s -VERSion [ Copyright ]\n", progname);
	fprintf(stderr, "       %s -VERSion License\n", progname);
	exit(1);
}


static void version_license _((void));

static void
version_license()
{
	help("dns-license", usage);
}


typedef struct table_t table_t;
struct table_t
{
	char	*name;
	void	(*func)_((void));
};


static	table_t	table[] =
{
	{ "Copyright",		version_copyright,	},
	{ "License",		version_license,	},
};


void
version()
{
	void	(*func)_((void));

	arglex();
	if (arglex_token == arglex_token_string)
	{
		int		nhit;
		table_t		*tp;
		table_t		*hit[SIZEOF(table)];
		int		j;
		size_t		len;
		char		*buf;

		nhit = 0;
		for (tp = table; tp < ENDOF(table); ++tp)
		{
			if (argcmp(tp->name, arglex_value.alv_string))
				hit[nhit++] = tp;
		}
		switch (nhit)
		{
		case 0:
			fatal
			(
				"version information name \"%s\" unknown",
				arglex_value.alv_string
			);
	
		case 1:
			break;
	
		default:
			len = strlen(hit[0]->name) + 1;
			for (j = 1; j < nhit; ++j)
				len += strlen(hit[j]->name) + 2;
			buf = mem_alloc(len);
			strcpy(buf, hit[j]->name);
			for (j = 1; j < nhit; ++j)
			{
				strcat(buf, ", ");
				strcat(buf, hit[j]->name);
			}
			fatal
			(
			       "version information name \"%s\" ambiguous (%s)",
				arglex_value.alv_string,
				buf
			);
		}
		arglex();
		func = hit[0]->func;
	}
	else
		func = version_copyright;
	if (arglex_token != arglex_token_eoln)
		usage();

	func();
}
