/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1991, 1992, 1993, 1994, 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/strlist.c
 */

#ifndef COMMON_STRLIST_H
#define COMMON_STRLIST_H

#include <str.h>

typedef struct strlist_ty strlist_ty;
struct	strlist_ty
{
	size_t		nstrings;
	size_t		nstrings_max;
	string_ty	**string;
};

int strlist_member _((strlist_ty *, string_ty *));
string_ty *wl2str _((strlist_ty *, int, int, char *));
void str2wl _((strlist_ty *, string_ty *, char *, int));
void strlist_append _((strlist_ty *, string_ty *));
void strlist_prepend _((strlist_ty *, string_ty *));
void strlist_append_unique _((strlist_ty *, string_ty *));
void strlist_copy _((strlist_ty *, strlist_ty *));
void strlist_delete _((strlist_ty *, string_ty *));
void strlist_free _((strlist_ty *));
void strlist_zero _((strlist_ty *));
void strlist_sort _((strlist_ty *));

#endif /* COMMON_STRLIST_H */
