/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to find types by name
 */

#include <ac/ctype.h>

#include <srrf.h>


static int compare _((char *, char *));

static int
compare(formal, actual)
	char		*formal;
	char		*actual;
{
	char		fc;
	char		ac;
	char		*ep;

	for (;;)
	{
		fc = *formal++;
		switch (fc)
		{
		case 0:
			return !*actual;
			
		case '?':
			if (!*actual++)
				return 0;
			break;

		case '*':
			for (;;)
			{
				fc = *formal++;
				if (fc == '?')
				{
					if (!*actual++)
						return 0;
				}
				else if (fc != '*')
					break;
			}
			if (!*formal)
				return 1;
			for (ep = actual + strlen(actual); ep >= actual; --ep)
				if (compare(formal, ep))
					return 1;
			return 0;

		default:
			if (isupper(fc))
				fc = tolower(fc);
			ac = *actual++;
			if (isupper(ac))
				ac = tolower(ac);
			if (fc != ac)
				return 0;
			break;
		}
	}
}


srrf_type_ty *
srrf_type_by_name(c, name)
	srrf_class_ty	*c;
	char		*name;
{
	size_t		j;
	srrf_type_ty	*t;

	for (j = 0; j < c->ntypes; ++j)
	{
		t = &c->type[j];
		if (compare(t->name, name))
			return t;
	}
	return 0;
}
