/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate readers
 */

#include <srrf/reader.h>


srrf_list_ty *
srrf_reader(filename, verbose, delete_foreign_names)
	char		*filename;
	int		verbose;
	int		delete_foreign_names;
{
	srrf_list_ty	*rlp;
	srrf_t		*rp;

	/*
	 * open the input file
	 */
	srrf_open(filename);

	/*
	 * read the file contents
	 */
	rlp = srrf_list_alloc();
	for (;;)
	{
		if (delete_foreign_names)
			rp = srrf_read_dfn();
		else
			rp = srrf_read();
		if (!rp)
			break;
		if (verbose)
			srrf_print(stderr, rp);
		srrf_list_append(rlp, rp);
	}

	/*
	 * close the input file
	 */
	srrf_close();

	/*
	 * check for host and address duplicates
	 */
	srrf_check_for_duplicates(rlp->record, rlp->nrecords, filename);

	/*
	 * return the list to the caller
	 */
	return rlp;
}
