/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate privates
 */

#include <srrf/private.h>


static string_ty *domain;


void
srrf_private_domain_set(s)
	string_ty		*s;
{
	if (domain)
	{
		str_free(domain);
		domain = 0;
	}
	if (s)
		domain = str_copy(s);
}


string_ty *
srrf_private_domain_get()
{
	return domain;
}


int
srrf_private_domain_member(name)
	string_ty	*name;
{
	if (!domain)
		return 0;
	if (name->str_length < domain->str_length)
		return 0;
	if (name->str_length == domain->str_length)
		return str_equal(name, domain);
	return
	(
		name->str_text[name->str_length - domain->str_length - 1] == '.'
	&&
		!memcmp(name->str_text + name->str_length - domain->str_length, domain->str_text, domain->str_length)
	);
}
