/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate lists
 */

#include <mem.h>
#include <srrf/list.h>


srrf_list_ty *
srrf_list_alloc()
{
	srrf_list_ty	*rlp;

	rlp = mem_alloc(sizeof(srrf_list_ty));
	rlp->nrecords = 0;
	rlp->nrecords_max = 0;
	rlp->record = 0;
	return rlp;
}


void
srrf_list_free(rlp)
	srrf_list_ty	*rlp;
{
	size_t		j;

	for (j = 0; j < rlp->nrecords; ++j)
		srrf_free(rlp->record[j]);
	if (rlp->record)
		mem_free(rlp->record);
	mem_free(rlp);
}


void
srrf_list_append(rlp, rp)
	srrf_list_ty	*rlp;
	srrf_t		*rp;
{
	if (rlp->nrecords >= rlp->nrecords_max)
	{
		size_t		nbytes;

		rlp->nrecords_max = rlp->nrecords_max * 2 + 4;
		nbytes = rlp->nrecords_max * sizeof(rlp->record[0]);
		rlp->record = mem_change_size(rlp->record, nbytes);
	}
	rlp->record[rlp->nrecords++] = rp;
}
