/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate ethers
 */

#include <ac/ctype.h>
#include <ac/string.h>

#include <mac.h>
#include <mem.h>
#include <srrf.h>
#include <srrf/private.h>


static void a_check _((srrf_t *));

static void
a_check(rp)
	srrf_t		*rp;
{
	string_ty	*tmp;

	tmp = mac_cannonicalize(rp->arg.string[0]);
	if (tmp)
	{
		/*
		 * replace the address given with one
		 * in a canonical form.
		 */
		str_free(rp->arg.string[0]);
		rp->arg.string[0] = tmp;
	}
	else
	{
		srrf_lex_error
		(
			"the string \"%s\" is not a legal Ethernet address",
			rp->arg.string[0]->str_text
		);
	}
}


static srrf_type_ty type[] =
{
	{ "a",		1, a_check,	},
};


/*
 * This symbol describes the class.
 * It should be the only symbol exported from this file.
 */
srrf_class_ty srrf_class_ether =
{
	"ether",
	type,
	SIZEOF(type)
};
